/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.search.solr.internal.AbstractSolrInstance;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Named(value="remote")
@Singleton
public class RemoteSolrInstance
extends AbstractSolrInstance {
    public static final String TYPE = "remote";
    public static final String DEFAULT_REMOTE_URL = "http://localhost:8983/solr/";
    public static final String CONFIGURATION_ZIP_FILE_NAME = "conf.zip";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private SolrConfiguration configuration;

    public void initialize() throws InitializationException {
        String remoteURL = this.configuration.getInstanceConfiguration(TYPE, "url", DEFAULT_REMOTE_URL);
        this.server = new HttpSolrClient(remoteURL);
    }

    public void generateAndAttachConfigurationZipIfNotExist() throws Exception {
        DocumentReference configDocumentReference;
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        XWikiDocument configurationDocument = xwiki.getDocument(configDocumentReference = new DocumentReference(context.getMainXWiki(), "XWiki", "SolrSearchAdmin"), context);
        XWikiAttachment configurationZipAttachment = configurationDocument.getAttachment(CONFIGURATION_ZIP_FILE_NAME);
        if (configurationZipAttachment == null) {
            try (InputStream inputStream = this.configuration.getHomeDirectoryConfiguration();){
                configurationDocument.addAttachment(CONFIGURATION_ZIP_FILE_NAME, inputStream, context);
                xwiki.saveDocument(configurationDocument, "Attach default SOLR configuration", context);
            }
        }
    }
}

