/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.xwiki.bridge.event.AbstractDocumentEvent;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.event.filter.EventFilter;
import org.xwiki.observation.event.filter.RegexEventFilter;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.search.solr.internal.api.SolrInstance;

@Component
@Named(value="solr.availablelocales")
@Singleton
public class SolrIndexAvailableLocalesListener
implements EventListener {
    private static final String PREFERENCEDOCUMENT_REGEX = ".*:XWiki.XWikiPreferences";
    private static final List<Event> EVENTS = Arrays.asList(new DocumentUpdatedEvent((EventFilter)new RegexEventFilter(".*:XWiki.XWikiPreferences")), new DocumentCreatedEvent((EventFilter)new RegexEventFilter(".*:XWiki.XWikiPreferences")), new ApplicationReadyEvent(), new WikiReadyEvent(), new ApplicationReadyEvent());
    private Map<String, Set<Locale>> localesCache = new ConcurrentHashMap<String, Set<Locale>>();
    @Inject
    private Logger logger;
    @Inject
    private Provider<SolrInstance> solrInstanceProvider;
    @Inject
    private Provider<SolrIndexer> solrIndexer;
    @Inject
    private DocumentReferenceResolver<SolrDocument> solrDocumentReferenceResolver;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiContext xcontext = (XWikiContext)data;
        String wiki = xcontext.getWikiId();
        Set<Locale> oldLocales = this.localesCache.get(wiki);
        List availableLocales = xcontext.getWiki().getAvailableLocales(xcontext);
        this.localesCache.put(wiki, new HashSet(availableLocales));
        try {
            Collection newLocales;
            if (oldLocales != null && event instanceof AbstractDocumentEvent && !(newLocales = CollectionUtils.subtract((Iterable)availableLocales, oldLocales)).isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (Locale newLocale : newLocales) {
                    for (Locale locale : this.getParentLocales(newLocale)) {
                        if (builder.length() > 0) {
                            builder.append(" OR ");
                        }
                        builder.append("doclocale");
                        builder.append(':');
                        builder.append('\"');
                        builder.append(locale.toString());
                        builder.append('\"');
                    }
                }
                SolrQuery solrQuery = new SolrQuery(builder.toString());
                solrQuery.setFields(new String[]{"wiki", "spaces", "name", "doclocale"});
                solrQuery.addFilterQuery(new String[]{"type:" + EntityType.DOCUMENT.name()});
                StreamingResponseCallback callback = new StreamingResponseCallback(){

                    public void streamSolrDocument(SolrDocument doc) {
                        ((SolrIndexer)SolrIndexAvailableLocalesListener.this.solrIndexer.get()).index((EntityReference)SolrIndexAvailableLocalesListener.this.solrDocumentReferenceResolver.resolve((Object)doc, new Object[0]), true);
                    }

                    public void streamDocListInfo(long numFound, long start, Float maxScore) {
                    }
                };
                ((SolrInstance)this.solrInstanceProvider.get()).queryAndStreamResponse((SolrParams)solrQuery, callback);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to handle event [{}] with source [{}]", new Object[]{event, source, e});
        }
    }

    private Set<Locale> getParentLocales(Locale locale) {
        HashSet<Locale> parentLocales = new HashSet<Locale>(LocaleUtils.localeLookupList((Locale)locale, (Locale)Locale.ROOT));
        parentLocales.remove(locale);
        return parentLocales;
    }
}

