/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.solr.internal;

import com.xpn.xwiki.XWikiContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.search.solr.internal.api.SolrInstance;

@Component
@Named(value="solr")
@Singleton
public class SolrQueryExecutor
implements QueryExecutor {
    public static final String SOLR = "solr";
    private static final String PARAM_SUPPORTED_LOCALES = "xwiki.supportedLocales";
    @Inject
    protected Logger logger;
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    protected Provider<SolrInstance> solrInstanceProvider;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public <T> List<T> execute(Query query) throws QueryException {
        try {
            SolrInstance solrInstance = (SolrInstance)this.solrInstanceProvider.get();
            SolrQuery solrQuery = this.createSolrQuery(query);
            QueryResponse response = solrInstance.query((SolrParams)solrQuery);
            this.filterResponse(response);
            return Arrays.asList(response);
        }
        catch (Exception e) {
            throw new QueryException("Exception while executing query", query, (Throwable)e);
        }
    }

    private SolrQuery createSolrQuery(Query query) {
        SolrQuery solrQuery = new SolrQuery(query.getStatement());
        if (query.getOffset() > 0) {
            solrQuery.setStart(Integer.valueOf(query.getOffset()));
        }
        if (query.getLimit() > 0) {
            solrQuery.setRows(Integer.valueOf(query.getLimit()));
        }
        for (Map.Entry entry : query.getNamedParameters().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Iterable) {
                solrQuery.set((String)entry.getKey(), this.toStringArray((Iterable)value));
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                solrQuery.set((String)entry.getKey(), this.toStringArray(value));
                continue;
            }
            solrQuery.set((String)entry.getKey(), new String[]{String.valueOf(value)});
        }
        if (!solrQuery.getParameterNames().contains(PARAM_SUPPORTED_LOCALES)) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            solrQuery.set(PARAM_SUPPORTED_LOCALES, new String[]{StringUtils.join((Collection)xcontext.getWiki().getAvailableLocales(xcontext), (String)",")});
        }
        return solrQuery;
    }

    private String[] toStringArray(Object array) {
        int length = Array.getLength(array);
        String[] args = new String[length];
        for (int i = 0; i < length; ++i) {
            args[i] = String.valueOf(Array.get(array, i));
        }
        return args;
    }

    private String[] toStringArray(Iterable iterable) {
        ArrayList<String> args = new ArrayList<String>();
        for (Object obj : iterable) {
            args.add(String.valueOf(obj));
        }
        return args.toArray(new String[args.size()]);
    }

    protected void filterResponse(QueryResponse response) {
        SolrDocumentList results = response.getResults();
        long numFound = results.getNumFound();
        for (SolrDocument result : new ArrayList(results)) {
            try {
                DocumentReference resultDocumentReference = new DocumentReference((String)result.get((Object)"wiki"), (String)result.get((Object)"space"), (String)result.get((Object)"name"));
                if (this.documentAccessBridge.exists(resultDocumentReference) && this.documentAccessBridge.isDocumentViewable(resultDocumentReference)) continue;
                results.remove((Object)result);
                --numFound;
            }
            catch (Exception e) {
                this.logger.warn("Skipping bad result: {}", (Object)result, (Object)e);
            }
        }
        if (numFound < 0L) {
            numFound = 0L;
        }
        results.setNumFound(numFound);
    }
}

