/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.rest;

import com.xpn.xwiki.XWikiException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.search.AbstractSearchSource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;

@Component
@Named(value="solr")
@Singleton
public class SOLRSearchSource
extends AbstractSearchSource {
    @Inject
    protected QueryManager queryManager;

    public List<SearchResult> search(String queryString, String defaultWikiName, String wikis, boolean hasProgrammingRights, String orderField, String order, boolean distinct, int number, int start, Boolean withPrettyNames, String className, UriInfo uriInfo) throws Exception {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (queryString == null) {
            return result;
        }
        if (defaultWikiName == null && wikis == null) {
            return result;
        }
        Query query = this.queryManager.createQuery(queryString, "solr");
        ArrayList<String> fq = new ArrayList<String>();
        fq.add("{!tag=type}type:(\"DOCUMENT\")");
        if (!hasProgrammingRights) {
            fq.add("{!tag=hidden}hidden:(false)");
        }
        if (StringUtils.isNotBlank((CharSequence)wikis)) {
            String[] strings = StringUtils.split((String)wikis, (char)',');
            if (strings.length == 1) {
                fq.add("{!tag=wiki}wiki:(\"" + strings[0] + "\")");
            } else if (strings.length > 1) {
                StringBuilder builder = new StringBuilder();
                for (String str : strings) {
                    if (builder.length() > 0) {
                        builder.append(" OR ");
                    }
                    builder.append('\'');
                    builder.append(str);
                    builder.append('\'');
                }
                fq.add("{!tag=wiki}wiki:(" + builder + ")");
            }
        }
        query.bindValue("fq", fq);
        query.bindValue("qf", (Object)"title^10.0 name^10.0 doccontent^2.0 objcontent^0.4 filename^0.4 attcontent^0.4 doccontentraw^0.4 author_display^0.08 creator_display^0.08 comment^0.016 attauthor_display^0.016 space^0.016");
        if (!StringUtils.isBlank((CharSequence)orderField)) {
            if ("desc".equals(order)) {
                query.bindValue("sort", (Object)(orderField + " desc"));
            } else {
                query.bindValue("sort", (Object)(orderField + " asc"));
            }
        }
        query.setLimit(number).setOffset(start);
        try {
            QueryResponse response = (QueryResponse)query.execute().get(0);
            SolrDocumentList documents = response.getResults();
            for (SolrDocument document : documents) {
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setPageFullName((String)document.get((Object)"fullname"));
                searchResult.setTitle((String)document.get((Object)"title"));
                searchResult.setWiki((String)document.get((Object)"wiki"));
                searchResult.setSpace((String)document.get((Object)"space"));
                searchResult.setPageName((String)document.get((Object)"name"));
                searchResult.setVersion((String)document.get((Object)"version"));
                searchResult.setType("page");
                searchResult.setId(Utils.getPageId((String)searchResult.getWiki(), (String)searchResult.getSpace(), (String)searchResult.getPageName()));
                searchResult.setScore(Float.valueOf(((Number)document.get((Object)"score")).floatValue()));
                searchResult.setAuthor((String)document.get((Object)"author"));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)document.get((Object)"date"));
                searchResult.setModified(calendar);
                if (withPrettyNames.booleanValue()) {
                    searchResult.setAuthorName((String)document.get((Object)"author_display"));
                }
                Locale locale = LocaleUtils.toLocale((String)((String)document.get((Object)"doclocale")));
                String pageUri = null;
                if (Locale.ROOT == locale) {
                    pageUri = Utils.createURI((URI)uriInfo.getBaseUri(), PageResource.class, (Object[])new Object[]{searchResult.getWiki(), searchResult.getSpace(), searchResult.getPageName()}).toString();
                } else {
                    searchResult.setLanguage(locale.toString());
                    pageUri = Utils.createURI((URI)uriInfo.getBaseUri(), PageTranslationResource.class, (Object[])new Object[]{searchResult.getSpace(), searchResult.getPageName(), locale}).toString();
                }
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                result.add(searchResult);
            }
        }
        catch (Exception e) {
            throw new XWikiException(0, 0, "Error performing solr search", (Throwable)e);
        }
        return result;
    }
}

