/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.cache.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityEntry;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.cache.ConflictingInsertionException;
import org.xwiki.security.authorization.cache.ParentEntryEvictedException;
import org.xwiki.security.authorization.cache.SecurityCache;

@Component
@Singleton
public class DefaultSecurityCache
implements SecurityCache,
Initializable {
    private static final int DEFAULT_CAPACITY = 500;
    @Inject
    private Logger logger;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    @Inject
    private EntityReferenceSerializer<String> keySerializer;
    @Inject
    private CacheManager cacheManager;
    private Cache<SecurityCacheEntry> cache;

    private Cache<SecurityCacheEntry> newCache() throws InitializationException {
        CacheConfiguration cacheConfig = new CacheConfiguration();
        cacheConfig.setConfigurationId("platform.security.authorization.cache");
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setMaxEntries(500);
        cacheConfig.put((Object)"eviction", (Object)lru);
        try {
            return this.cacheManager.createNewCache(cacheConfig);
        }
        catch (Exception e) {
            throw new InitializationException("Unable to create the security cache with a capacity of " + lru.getMaxEntries(), (Throwable)e);
        }
    }

    public void initialize() throws InitializationException {
        this.cache = this.newCache();
        this.cache.addCacheEntryListener((CacheEntryListener)new Listener());
    }

    private String getEntryKey(SecurityReference reference) {
        return (String)this.keySerializer.serialize((EntityReference)reference, new Object[0]);
    }

    private String getEntryKey(UserSecurityReference userReference, SecurityReference reference) {
        return (String)this.keySerializer.serialize((EntityReference)userReference, new Object[0]) + "@@" + (String)this.keySerializer.serialize((EntityReference)reference, new Object[0]);
    }

    private String getEntryKey(SecurityEntry entry) {
        if (entry instanceof SecurityAccessEntry) {
            return this.getEntryKey((SecurityAccessEntry)entry);
        }
        return this.getEntryKey((SecurityRuleEntry)entry);
    }

    private String getEntryKey(SecurityRuleEntry entry) {
        return this.getEntryKey(entry.getReference());
    }

    private String getEntryKey(SecurityAccessEntry entry) {
        return this.getEntryKey(entry.getUserReference(), entry.getReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityCacheEntry getEntry(SecurityReference reference) {
        this.readLock.lock();
        try {
            SecurityCacheEntry securityCacheEntry = (SecurityCacheEntry)this.cache.get(this.getEntryKey(reference));
            return securityCacheEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityCacheEntry getEntry(UserSecurityReference userReference, SecurityReference reference) {
        this.readLock.lock();
        try {
            SecurityCacheEntry securityCacheEntry = (SecurityCacheEntry)this.cache.get(this.getEntryKey(userReference, reference));
            return securityCacheEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isAlreadyInserted(String key, SecurityEntry entry) throws ConflictingInsertionException {
        SecurityCacheEntry oldEntry = (SecurityCacheEntry)this.cache.get(key);
        if (oldEntry != null) {
            if (!oldEntry.getEntry().equals(entry)) {
                throw new ConflictingInsertionException();
            }
            return true;
        }
        return false;
    }

    @Override
    public void add(SecurityRuleEntry entry) throws ParentEntryEvictedException, ConflictingInsertionException {
        this.add(entry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SecurityRuleEntry entry, Collection<GroupSecurityReference> groups) throws ConflictingInsertionException, ParentEntryEvictedException {
        String key = this.getEntryKey(entry);
        this.writeLock.lock();
        try {
            if (this.isAlreadyInserted(key, entry)) {
                return;
            }
            SecurityCacheEntry newEntry = groups == null || groups.isEmpty() ? new SecurityCacheEntry(entry) : new SecurityCacheEntry(entry, groups);
            this.cache.set(key, (Object)newEntry);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Added rule entry [{}] into the cache.", (Object)key);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SecurityAccessEntry entry) throws ParentEntryEvictedException, ConflictingInsertionException {
        String key = this.getEntryKey(entry);
        this.writeLock.lock();
        try {
            if (this.isAlreadyInserted(key, entry)) {
                return;
            }
            SecurityCacheEntry newEntry = new SecurityCacheEntry(entry);
            this.cache.set(key, (Object)newEntry);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Added access entry [{}] into the cache.", (Object)key);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public SecurityAccessEntry get(UserSecurityReference user, SecurityReference entity) {
        SecurityCacheEntry entry = this.getEntry(user, entity);
        if (entry == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Miss read access entry for [{}].", (Object)this.getEntryKey(user, entity));
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Success read access entry for [{}].", (Object)this.getEntryKey(user, entity));
        }
        return (SecurityAccessEntry)entry.getEntry();
    }

    @Override
    public SecurityRuleEntry get(SecurityReference entity) {
        SecurityCacheEntry entry = this.getEntry(entity);
        if (entry == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Miss read rule entry for [{}].", (Object)this.getEntryKey(entity));
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Success read rule entry for [{}].", (Object)this.getEntryKey(entity));
        }
        return (SecurityRuleEntry)entry.getEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(UserSecurityReference user, SecurityReference entity) {
        this.writeLock.lock();
        try {
            SecurityCacheEntry entry = this.getEntry(user, entity);
            if (entry != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Remove outdated access entry for [{}].", (Object)this.getEntryKey(user, entity));
                }
                if (entry.dispose()) {
                    this.cache.remove(entry.getKey());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(SecurityReference entity) {
        this.writeLock.lock();
        try {
            SecurityCacheEntry entry = this.getEntry(entity);
            if (entry != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Remove outdated rule entry for [{}].", (Object)this.getEntryKey(entity));
                }
                if (entry.dispose()) {
                    this.cache.remove(entry.getKey());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private class Listener
    implements CacheEntryListener<SecurityCacheEntry> {
        private Listener() {
        }

        public void cacheEntryAdded(CacheEntryEvent<SecurityCacheEntry> securityCacheEntryCacheEntryEvent) {
        }

        public void cacheEntryRemoved(CacheEntryEvent<SecurityCacheEntry> event) {
            if (((SecurityCacheEntry)event.getEntry().getValue()).dispose()) {
                if (DefaultSecurityCache.this.logger.isDebugEnabled()) {
                    DefaultSecurityCache.this.logger.debug("Evicting entry [{}].", (Object)event.getEntry().getKey());
                }
            } else if (DefaultSecurityCache.this.logger.isDebugEnabled()) {
                DefaultSecurityCache.this.logger.debug("Removed entry [{}].", (Object)event.getEntry().getKey());
            }
        }

        public void cacheEntryModified(CacheEntryEvent<SecurityCacheEntry> securityCacheEntryCacheEntryEvent) {
        }
    }

    private class SecurityCacheEntry {
        private SecurityEntry entry;
        private Collection<SecurityCacheEntry> parents;
        private Collection<SecurityCacheEntry> children;
        private boolean disposed;

        SecurityCacheEntry(SecurityRuleEntry entry) throws ParentEntryEvictedException {
            this.entry = entry;
            SecurityReference parentReference = entry.getReference().getParentSecurityReference();
            if (parentReference != null) {
                SecurityCacheEntry parent = DefaultSecurityCache.this.getEntry(parentReference);
                if (parent == null) {
                    throw new ParentEntryEvictedException();
                }
                this.parents = Arrays.asList(parent);
                parent.addChild(this);
                this.logNewEntry();
            } else {
                this.parents = null;
                this.logNewEntry();
            }
        }

        SecurityCacheEntry(SecurityAccessEntry entry) throws ParentEntryEvictedException {
            SecurityCacheEntry parent2;
            this.entry = entry;
            boolean isSelf = entry.getReference().equals((Object)entry.getUserReference());
            SecurityCacheEntry parent1 = DefaultSecurityCache.this.getEntry(entry.getReference());
            SecurityCacheEntry securityCacheEntry = parent2 = isSelf ? parent1 : DefaultSecurityCache.this.getEntry(entry.getUserReference());
            if (parent1 == null || parent2 == null) {
                throw new ParentEntryEvictedException();
            }
            this.parents = isSelf ? Arrays.asList(parent1) : Arrays.asList(parent1, parent2);
            parent1.addChild(this);
            if (!isSelf) {
                parent2.addChild(this);
            }
            this.logNewEntry();
        }

        SecurityCacheEntry(SecurityRuleEntry entry, Collection<GroupSecurityReference> groups) throws ParentEntryEvictedException {
            this.entry = entry;
            SecurityReference entity = entry.getReference();
            SecurityReference parentReference = entry.getReference().getParentSecurityReference();
            int parentSize = groups.size() + (parentReference == null ? 0 : 1);
            if (parentSize > 0) {
                this.parents = new ArrayList<SecurityCacheEntry>(parentSize);
                if (parentReference != null) {
                    SecurityCacheEntry parent = DefaultSecurityCache.this.getEntry(entity.getParentSecurityReference());
                    if (parent == null) {
                        throw new ParentEntryEvictedException();
                    }
                    this.parents.add(parent);
                    parent.addChild(this);
                }
                for (GroupSecurityReference group : groups) {
                    if (group.equals((Object)parentReference)) continue;
                    SecurityCacheEntry parent = DefaultSecurityCache.this.getEntry(group);
                    if (parent == null) {
                        throw new ParentEntryEvictedException();
                    }
                    this.parents.add(parent);
                    parent.addChild(this);
                }
                this.logNewEntry();
            } else {
                this.parents = null;
                this.logNewEntry();
            }
        }

        private void logNewEntry() {
            if (DefaultSecurityCache.this.logger.isDebugEnabled()) {
                if (this.parents == null || this.parents.size() == 0) {
                    DefaultSecurityCache.this.logger.debug("New orphan entry [{}].", (Object)this.getKey());
                    return;
                }
                StringBuilder sb = new StringBuilder("New entry [");
                sb.append(this.getKey()).append("] as child of ");
                boolean first = true;
                for (SecurityCacheEntry parent : this.parents) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append('[').append(parent.getKey()).append(']');
                }
                sb.append(".");
                DefaultSecurityCache.this.logger.debug(sb.toString());
            }
        }

        SecurityEntry getEntry() {
            return this.entry;
        }

        String getKey() {
            return DefaultSecurityCache.this.getEntryKey(this.entry);
        }

        boolean dispose() {
            if (this.disposed) {
                return false;
            }
            if (this.parents != null) {
                for (SecurityCacheEntry parent : this.parents) {
                    parent.removeChild(this);
                }
                this.parents = null;
            }
            if (this.children != null) {
                Collection<SecurityCacheEntry> childrenToClean = this.children;
                this.children = null;
                for (SecurityCacheEntry child : childrenToClean) {
                    if (!child.dispose()) continue;
                    DefaultSecurityCache.this.cache.remove(child.getKey());
                }
            }
            String key = this.getKey();
            this.disposed = true;
            return true;
        }

        private void addChild(SecurityCacheEntry entry) {
            if (this.children == null) {
                this.children = new ArrayList<SecurityCacheEntry>();
            }
            this.children.add(entry);
        }

        private void removeChild(SecurityCacheEntry entry) {
            if (this.children != null) {
                this.children.remove(entry);
                if (DefaultSecurityCache.this.logger.isDebugEnabled()) {
                    DefaultSecurityCache.this.logger.debug("Remove child [{}] from [{}].", (Object)entry.getKey(), (Object)this.getKey());
                }
            }
        }
    }
}

