/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.security.authentication.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authentication.api.AuthenticationFailureEvent;

/**
 * Logger listener for {@link AuthenticationFailureEvent} that warn about the authentication failures.
 *
 * @version $Id: 20fe79cbeaf0790a6b9a8655ecdc72e82ac35a8d $
 * @since 11.6RC1
 */
@Component
@Singleton
@Named("org.xwiki.security.authentication.internal.AuthenticationFailureLoggerListener")
public class AuthenticationFailureLoggerListener extends AbstractEventListener
{
    @Inject
    private Logger logger;

    /**
     * Default constructor.
     */
    public AuthenticationFailureLoggerListener()
    {
        super(AuthenticationFailureLoggerListener.class.getName(), new AuthenticationFailureEvent());
    }

    @Override
    public void onEvent(Event event, Object source, Object data)
    {
        logger.warn("Authentication failure with login [{}]", source);
    }
}
