/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.script;

import com.xpn.xwiki.util.Programming;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authentication.api.AuthenticationConfiguration;
import org.xwiki.security.authentication.api.AuthenticationFailureManager;
import org.xwiki.security.authentication.api.AuthenticationFailureStrategy;
import org.xwiki.stability.Unstable;

@Unstable
@Component
@Named(value="security.authentication")
@Singleton
public class AuthenticationScriptService
implements ScriptService {
    public static final String ID = "authentication";
    @Inject
    private AuthenticationFailureManager authenticationFailureManager;
    @Inject
    private AuthenticationConfiguration authenticationConfiguration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public String getForm(String username) {
        return this.authenticationFailureManager.getForm(username);
    }

    public String getErrorMessage(String username) {
        return this.authenticationFailureManager.getErrorMessage(username);
    }

    public Set<String> getAuthenticationFailureAvailableStrategies() {
        try {
            return this.componentManager.getInstanceMap(AuthenticationFailureStrategy.class).keySet();
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error while getting the list of available authentication strategies.");
            return Collections.emptySet();
        }
    }

    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    @Programming
    public void resetAuthenticationFailureCounter(String username) {
        this.authenticationFailureManager.resetAuthenticationFailureCounter(username);
    }
}

