/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.user.api.XWikiGroupService;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.cache.SecurityCache;
import org.xwiki.security.authorization.event.RightUpdatedEvent;
import org.xwiki.security.internal.XWikiConstants;

@Component
@Named(value="org.xwiki.security.authorization.internal.DefaultSecurityCacheRulesInvalidatorListener")
@Singleton
public class DefaultSecurityCacheRulesInvalidatorListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.security.authorization.internal.DefaultSecurityCacheRulesInvalidatorListener";
    private static final LocalDocumentReference XWIKISERVER_CLASS = new LocalDocumentReference("XWiki", "XWikiServerClass");
    private static final Set<LocalDocumentReference> RIGHT_OBJECTS = new HashSet<LocalDocumentReference>(Arrays.asList(XWikiConstants.GROUP_CLASS_REFERENCE, XWikiConstants.GLOBAL_CLASS_REFERENCE, XWikiConstants.LOCAL_CLASS_REFERENCE, XWIKISERVER_CLASS));
    @Inject
    private Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityReferenceFactory securityReferenceFactory;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    @Named(value="user")
    private DocumentReferenceResolver<String> userResolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ObservationManager observation;

    public DefaultSecurityCacheRulesInvalidatorListener() {
        super(NAME, new Event[]{new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent()});
    }

    private boolean isGroupDocument(XWikiDocument document) {
        DocumentReference docRef = document.getDocumentReference();
        DocumentReference groupClass = this.resolver.resolve((Object)"XWiki.XWikiGroups", new Object[]{docRef});
        List objects = document.getXObjects(groupClass);
        return objects != null && objects.size() > 0;
    }

    public void invalidateGroupMembers(DocumentReference group, SecurityCache securityCache) throws AuthorizationException {
        try {
            Collection memberNames;
            XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
            XWikiGroupService groupService = xwikiContext.getWiki().getGroupService(xwikiContext);
            String groupName = (String)this.serializer.serialize((EntityReference)group, new Object[0]);
            WikiReference wikiReference = group.getWikiReference();
            int nb = 100;
            int i = 0;
            do {
                memberNames = groupService.getAllMembersNamesForGroup(groupName, 100, i * 100, xwikiContext);
                for (String member : memberNames) {
                    DocumentReference memberRef = this.userResolver.resolve((Object)member, new Object[]{wikiReference});
                    if (memberRef.equals((Object)group)) continue;
                    securityCache.remove((SecurityReference)this.securityReferenceFactory.newUserReference(memberRef));
                }
                ++i;
            } while (memberNames.size() == 100);
        }
        catch (XWikiException e) {
            throw new AuthorizationException("Failed to invalidate group member.", (Throwable)e);
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        DocumentReference ref = document.getDocumentReference();
        try {
            this.deliverUpdateEvent(ref);
            if (this.isGroupDocument(document)) {
                this.invalidateGroupMembers(ref, this.securityCache);
            }
        }
        catch (AuthorizationException e) {
            this.logger.error("Failed to invalidate group members on the document: {}", (Object)ref, (Object)e);
        }
        if (this.shouldSendRightUpdatedEvent(document, (XWikiContext)data)) {
            this.observation.notify((Event)new RightUpdatedEvent(), source);
        }
    }

    private boolean shouldSendRightUpdatedEvent(XWikiDocument document, XWikiContext xcontext) {
        List documentDiff = document.getObjectDiff(document.getOriginalDocument(), document, xcontext);
        for (List objecstDiff : documentDiff) {
            for (ObjectDiff objectDiff : objecstDiff) {
                if (!RIGHT_OBJECTS.contains(objectDiff.getXClassReference().getLocalDocumentReference())) continue;
                return true;
            }
        }
        return false;
    }

    private void deliverUpdateEvent(DocumentReference ref) {
        if (XWikiConstants.WIKI_DOC_REFERENCE.equals((EntityReference)ref, EntityType.SPACE)) {
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)ref.getWikiReference()));
        } else if (ref.getName().equals("WebPreferences")) {
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference(ref.getParent()));
        } else {
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)ref));
            if (ref.getName().startsWith("XWikiServer") && XWikiConstants.XWIKI_SPACE_REFERENCE.equals((EntityReference)ref.getLastSpaceReference(), EntityType.SPACE) && ref.getWikiReference().getName().equals(((XWikiContext)this.xcontextProvider.get()).getMainXWiki())) {
                this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)new WikiReference(ref.getName().substring("XWikiServer".length()).toLowerCase())));
            }
        }
    }
}

