/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiGroupService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.cache.SecurityCache;

@Component
@Named(value="org.xwiki.security.authorization.internal.DefaultSecurityCacheRulesInvalidator")
@Singleton
public class DefaultSecurityCacheRulesInvalidatorListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent());
    @Inject
    @Named(value="org.xwiki.security.authorization.internal.DefaultSecurityCacheRulesInvalidator")
    private ReadWriteLock readWriteLock;
    @Inject
    private Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityReferenceFactory securityReferenceFactory;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    @Named(value="user")
    private DocumentReferenceResolver<String> userResolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public String getName() {
        return "org.xwiki.security.authorization.internal.DefaultSecurityCacheRulesInvalidator";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    private static DocumentReference getDocumentReference(Object xwikiDocument) {
        XWikiDocument doc = (XWikiDocument)xwikiDocument;
        return doc.getDocumentReference();
    }

    private boolean isGroupDocument(Object source) {
        XWikiDocument doc = (XWikiDocument)source;
        DocumentReference docRef = doc.getDocumentReference();
        DocumentReference groupClass = this.resolver.resolve((Object)"XWiki.XWikiGroups", new Object[]{docRef});
        List objects = doc.getXObjects(groupClass);
        return objects != null && objects.size() > 0;
    }

    public void invalidateGroupMembers(DocumentReference group, SecurityCache securityCache) throws AuthorizationException {
        try {
            Collection memberNames;
            XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
            XWikiGroupService groupService = xwikiContext.getWiki().getGroupService(xwikiContext);
            String groupName = (String)this.serializer.serialize((EntityReference)group, new Object[0]);
            WikiReference wikiReference = group.getWikiReference();
            int nb = 100;
            int i = 0;
            do {
                memberNames = groupService.getAllMembersNamesForGroup(groupName, 100, i * 100, xwikiContext);
                for (String member : memberNames) {
                    DocumentReference memberRef = this.userResolver.resolve((Object)member, new Object[]{wikiReference});
                    if (memberRef.equals((Object)group)) continue;
                    securityCache.remove((SecurityReference)this.securityReferenceFactory.newUserReference(memberRef));
                }
                ++i;
            } while (memberNames.size() == 100);
        }
        catch (XWikiException e) {
            throw new AuthorizationException("Failed to invalidate group member.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event, Object source, Object data) {
        DocumentReference ref = DefaultSecurityCacheRulesInvalidatorListener.getDocumentReference(source);
        this.readWriteLock.writeLock().lock();
        try {
            this.deliverUpdateEvent(ref);
            if (this.isGroupDocument(source)) {
                this.invalidateGroupMembers(ref, this.securityCache);
            }
        }
        catch (AuthorizationException e) {
            this.logger.error("Failed to invalidate group members on the document: {}", (Object)ref, (Object)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void deliverUpdateEvent(DocumentReference ref) {
        if (ref.getName().equals("XWikiPreferences") && ref.getLastSpaceReference().getName().equals("XWiki")) {
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)ref.getWikiReference()));
        } else if (ref.getName().equals("WebPreferences")) {
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference(ref.getParent()));
        } else {
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)ref));
            if (ref.getName().startsWith("XWikiServer") && ref.getLastSpaceReference().getName().equals("XWiki") && ref.getWikiReference().getName().equals(((XWikiContext)this.xcontextProvider.get()).getMainXWiki())) {
                this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)new WikiReference(ref.getName().substring("XWikiServer".length()).toLowerCase())));
            }
        }
    }
}

