/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.skinx.internal.async;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.skinx.AbstractSkinExtensionPlugin;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.async.AsyncContextHandler;
import org.xwiki.skinx.SkinExtension;
import org.xwiki.skinx.internal.async.SkinExtensionInfo;

@Component
@Named(value="skinx")
@Singleton
public class SkinExtensionAsyncContextHandler
implements AsyncContextHandler {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    public void use(Collection<Object> values) {
        for (Object value : values) {
            this.use(value);
        }
    }

    private void use(Object value) {
        SkinExtension skinExtension;
        SkinExtensionInfo info = (SkinExtensionInfo)value;
        try {
            skinExtension = (SkinExtension)this.componentManager.getInstance(SkinExtension.class, info.getType());
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to load the skin extension with type [{}]", (Object)info.getType(), (Object)e);
            return;
        }
        if (info.getParameters() != null) {
            skinExtension.use(info.getResource(), info.getParameters());
        } else {
            skinExtension.use(info.getResource());
        }
    }

    public void addHTMLHead(StringBuilder head, Collection<Object> values) {
        this.addHTMLHead(head, values, true);
    }

    public void addHTMLHead(StringBuilder head, Collection<Object> values, boolean scripts) {
        this.addHTMLHead(head, values, scripts ? null : Boolean.FALSE);
    }

    private void addHTMLHead(StringBuilder head, Collection<Object> values, Boolean scripts) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        Vector plugins = xcontext.getWiki().getPluginManager().getPlugins("endParsing");
        for (Object value : values) {
            SkinExtensionInfo info = (SkinExtensionInfo)value;
            AbstractSkinExtensionPlugin skinPlugin = this.getPlugin(info.getType(), plugins);
            if (skinPlugin != null) {
                if (scripts != null && skinPlugin.getName().startsWith("js") != scripts.booleanValue()) continue;
                head.append(skinPlugin.getLink(info.getResource(), info.getParameters(), xcontext));
                continue;
            }
            this.logger.warn("Cannot find skin extension plugin for resource type [{}]", (Object)info.getType());
        }
    }

    public void addHTMLScripts(StringBuilder head, Collection<Object> values) {
        this.addHTMLHead(head, values, Boolean.TRUE);
    }

    private AbstractSkinExtensionPlugin getPlugin(String name, List<XWikiPluginInterface> plugins) {
        for (XWikiPluginInterface plugin : plugins) {
            if (!(plugin instanceof AbstractSkinExtensionPlugin) || !plugin.getName().equals(name)) continue;
            return (AbstractSkinExtensionPlugin)plugin;
        }
        return null;
    }
}

