/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.skinx.AbstractSkinExtensionPlugin;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.syntax.Syntax;

public abstract class AbstractDocumentSkinExtensionPlugin
extends AbstractSkinExtensionPlugin
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDocumentSkinExtensionPlugin.class);
    private static final String USE_FIELDNAME = "use";
    private Map<String, Set<String>> alwaysUsedExtensions;
    private final List<Event> events = new ArrayList<Event>(3);

    public AbstractDocumentSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.events.add((Event)new DocumentCreatedEvent());
        this.events.add((Event)new DocumentDeletedEvent());
        this.events.add((Event)new DocumentUpdatedEvent());
        this.events.add((Event)new WikiDeletedEvent());
    }

    public List<Event> getEvents() {
        return this.events;
    }

    protected abstract String getExtensionClassName();

    protected abstract String getExtensionName();

    public void init(XWikiContext context) {
        super.init(context);
        this.alwaysUsedExtensions = new HashMap<String, Set<String>>();
        this.getExtensionClass(context);
        ((ObservationManager)Utils.getComponent(ObservationManager.class)).addListener((EventListener)this);
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
        this.getExtensionClass(context);
    }

    @Override
    public Set<String> getAlwaysUsedExtensions(XWikiContext context) {
        String currentWiki = (String)StringUtils.defaultIfEmpty((CharSequence)context.getDatabase(), (CharSequence)context.getMainXWiki());
        if (this.alwaysUsedExtensions.get(currentWiki) != null) {
            return this.alwaysUsedExtensions.get(currentWiki);
        }
        HashSet<String> extensions = new HashSet<String>();
        String query = ", BaseObject as obj, StringProperty as use where obj.className='" + this.getExtensionClassName() + "'" + " and obj.name=doc.fullName and use.id.id=obj.id and use.id.name='use' and use.value='always'";
        try {
            for (String extension : context.getWiki().getStore().searchDocumentsNames(query, context)) {
                try {
                    XWikiDocument doc = context.getWiki().getDocument(extension, context);
                    if (!context.getWiki().getRightService().hasProgrammingRights(doc, context)) continue;
                    extensions.add(extension);
                }
                catch (XWikiException e1) {
                    LOGGER.error("Error while adding skin extension [{}] as always used. It will be ignored.", (Object)extension, (Object)e1);
                }
            }
            this.alwaysUsedExtensions.put(currentWiki, extensions);
            return extensions;
        }
        catch (XWikiException e) {
            LOGGER.error("Error while retrieving always used JS extensions", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public boolean hasPageExtensions(XWikiContext context) {
        XWikiDocument doc = context.getDoc();
        Vector objects = doc.getObjects(this.getExtensionClassName());
        if (objects != null) {
            for (BaseObject obj : objects) {
                if (obj == null || !obj.getStringValue(USE_FIELDNAME).equals("currentPage")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String endParsing(String content, XWikiContext context) {
        return super.endParsing(content, context);
    }

    private boolean setExtensionClassDocumentFields(XWikiDocument doc) {
        boolean needsUpdate = false;
        if (StringUtils.isBlank((CharSequence)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((CharSequence)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(doc.getCreator());
        }
        if (StringUtils.isBlank((CharSequence)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((CharSequence)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle("XWiki " + this.getExtensionName() + " Extension Class");
        }
        if (StringUtils.isBlank((CharSequence)doc.getContent()) || !Syntax.XWIKI_2_0.equals((Object)doc.getSyntax())) {
            doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
            doc.setSyntax(Syntax.XWIKI_2_0);
        }
        if (!doc.isHidden().booleanValue()) {
            needsUpdate = true;
            doc.setHidden(Boolean.valueOf(true));
        }
        return needsUpdate;
    }

    public BaseClass getExtensionClass(XWikiContext context) {
        try {
            XWikiDocument doc = context.getWiki().getDocument(this.getExtensionClassName(), context);
            boolean needsUpdate = false;
            String useOptions = "currentPage=Always on this page|onDemand=On demand|always=Always on this wiki";
            BaseClass bclass = doc.getXClass();
            if (context.get((Object)"initdone") != null) {
                return bclass;
            }
            bclass.setName(this.getExtensionClassName());
            needsUpdate |= bclass.addTextField("name", "Name", 30);
            needsUpdate |= bclass.addTextAreaField("code", "Code", 50, 20);
            needsUpdate |= bclass.addStaticListField(USE_FIELDNAME, "Use this extension", useOptions);
            needsUpdate |= bclass.addBooleanField("parse", "Parse content", "yesno");
            needsUpdate |= bclass.addStaticListField("cache", "Caching policy", "long|short|default|forbid");
            if (needsUpdate |= this.setExtensionClassDocumentFields(doc)) {
                context.getWiki().saveDocument(doc, context);
            }
            return bclass;
        }
        catch (Exception ex) {
            LOGGER.error("Cannot initialize skin extension class [{}]", (Object)this.getExtensionClassName(), (Object)ex);
            return null;
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            this.alwaysUsedExtensions.remove(((WikiDeletedEvent)event).getWikiId());
        } else {
            this.onDocumentEvent((XWikiDocument)source, (XWikiContext)data);
        }
    }

    private void onDocumentEvent(XWikiDocument document, XWikiContext context) {
        boolean remove = false;
        if (document.getObject(this.getExtensionClassName()) != null) {
            if (document.getObject(this.getExtensionClassName(), USE_FIELDNAME, "always", false) != null) {
                if (context.getWiki().getRightService().hasProgrammingRights(document, context)) {
                    this.getAlwaysUsedExtensions(context).add(document.getFullName());
                    return;
                }
                remove = true;
            } else {
                remove = true;
            }
        } else if (document.getOriginalDocument().getObject(this.getExtensionClassName()) != null) {
            remove = true;
        }
        if (remove) {
            this.getAlwaysUsedExtensions(context).remove(document.getFullName());
        }
    }
}

