/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web.sx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.sx.Extension;
import com.xpn.xwiki.web.sx.SxSource;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityException;

public class SxDocumentSource
implements SxSource {
    private static final String CONTENT_PROPERTY_NAME = "code";
    private static final String PARSE_CONTENT_PROPERTY_NAME = "parse";
    private static final String CACHE_POLICY_PROPERTY_NAME = "cache";
    private static final Logger LOGGER = LoggerFactory.getLogger(SxDocumentSource.class);
    private XWikiDocument document;
    private XWikiContext context;
    private Extension extension;

    public SxDocumentSource(XWikiContext context, Extension extension) {
        this.context = context;
        this.document = context.getDoc();
        this.extension = extension;
    }

    @Override
    public SxSource.CachePolicy getCachePolicy() {
        SxSource.CachePolicy finalCache = SxSource.CachePolicy.LONG;
        if (this.document.getObjects(this.extension.getClassName()) != null) {
            for (BaseObject sxObj : this.document.getObjects(this.extension.getClassName())) {
                if (sxObj == null) continue;
                try {
                    SxSource.CachePolicy cache = SxSource.CachePolicy.valueOf(StringUtils.upperCase((String)((String)StringUtils.defaultIfEmpty((CharSequence)sxObj.getStringValue(CACHE_POLICY_PROPERTY_NAME), (CharSequence)"LONG"))));
                    if (cache.compareTo(finalCache) <= 0) continue;
                    finalCache = cache;
                }
                catch (Exception exception) {
                    LOGGER.warn("SX object [{}#{}] has an invalid cache policy: [{}]", new Object[]{this.document.getFullName(), sxObj.getStringValue("name"), sxObj.getStringValue(CACHE_POLICY_PROPERTY_NAME)});
                }
            }
        }
        return finalCache;
    }

    @Override
    public String getContent() {
        StringBuilder resultBuilder = new StringBuilder();
        if (this.document.getObjects(this.extension.getClassName()) != null) {
            for (BaseObject sxObj : this.document.getObjects(this.extension.getClassName())) {
                if (sxObj == null) continue;
                String sxContent = sxObj.getLargeStringValue(CONTENT_PROPERTY_NAME);
                int parse = sxObj.getIntValue(PARSE_CONTENT_PROPERTY_NAME);
                if (parse == 1) {
                    try {
                        StringWriter writer = new StringWriter();
                        VelocityManager velocityManager = (VelocityManager)Utils.getComponent(VelocityManager.class);
                        VelocityEngine engine = velocityManager.getVelocityEngine();
                        try {
                            VelocityContext vcontext = velocityManager.getVelocityContext();
                            engine.startedUsingMacroNamespace(this.document.getPrefixedFullName());
                            velocityManager.getVelocityEngine().evaluate((Context)vcontext, (Writer)writer, this.document.getPrefixedFullName(), sxContent);
                            sxContent = writer.toString();
                        }
                        finally {
                            engine.stoppedUsingMacroNamespace(this.document.getPrefixedFullName());
                        }
                    }
                    catch (XWikiVelocityException ex) {
                        LOGGER.warn("Velocity errors while parsing skin extension [{}]: ", (Object)this.document.getPrefixedFullName(), (Object)ex.getMessage());
                    }
                }
                resultBuilder.append(String.valueOf(sxContent) + "\n");
            }
        }
        return resultBuilder.toString();
    }

    @Override
    public long getLastModifiedDate() {
        return this.document.getDate().getTime();
    }
}

