/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web.sx;

import com.xpn.xwiki.web.sx.Extension;
import com.xpn.xwiki.web.sx.SxCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.compressor.javascript.ErrorReporter;
import com.yahoo.platform.yui.compressor.javascript.EvaluatorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsExtension.class);

    @Override
    public String getClassName() {
        return "XWiki.JavaScriptExtension";
    }

    @Override
    public String getContentType() {
        return "text/javascript; charset=UTF-8";
    }

    @Override
    public SxCompressor getCompressor() {
        return new JsCompressor();
    }

    private static class JsCompressor
    implements SxCompressor {
        private JsCompressor() {
        }

        @Override
        public String compress(String source) {
            try {
                CustomErrorReporter reporter = new CustomErrorReporter();
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new StringReader(source), (ErrorReporter)reporter);
                StringWriter out = new StringWriter();
                compressor.compress((Writer)out, -1, true, false, false, false);
                return out.toString();
            }
            catch (IOException ex) {
                LOGGER.info("Failed to write the compressed output: " + ex.getMessage());
            }
            catch (EvaluatorException ex) {
                LOGGER.info("Failed to parse the JS extension: " + ex.getMessage());
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to compress JS extension: " + ex.getMessage());
            }
            return source;
        }

        private static class CustomErrorReporter
        implements ErrorReporter {
            private CustomErrorReporter() {
            }

            public void error(String message, String filename, int lineNumber, String context, int column) {
                LOGGER.warn(MessageFormat.format("Error at line {2}, column {3}: {0}. Caused by: [{1}]", message, context, lineNumber, column));
            }

            public EvaluatorException runtimeError(String message, String filename, int lineNumber, String context, int column) {
                LOGGER.error(MessageFormat.format("Runtime error minimizing JSX object: {0}", message));
                return null;
            }

            public void warning(String message, String filename, int lineNumber, String context, int column) {
                LOGGER.info(MessageFormat.format("Warning at line {2}, column {3}: {0}. Caused by: [{1}]", message, context, lineNumber, column));
            }
        }
    }
}

