/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.template.internal.macro;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.template.TemplateManager;
import org.xwiki.template.macro.TemplateMacroParameters;

@Component
@Named(value="template")
@Singleton
public class TemplateMacro
extends AbstractMacro<TemplateMacroParameters> {
    private static final String DESCRIPTION = "Insert a template.";
    @Inject
    private TemplateManager templates;

    public TemplateMacro() {
        super("Template", DESCRIPTION, TemplateMacroParameters.class);
        this.setPriority(10);
        this.setDefaultCategory("Internal");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(TemplateMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM result;
        try {
            result = this.templates.execute(parameters.getName());
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to execute template [" + parameters.getName() + "]", (Throwable)e);
        }
        if (parameters.isOutput()) {
            return result.getChildren();
        }
        return Collections.emptyList();
    }
}

