/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.test.integration.AntBuildListener;

public class XWikiExecutor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XWikiExecutor.class);
    public static final String DEFAULT_PORT = System.getProperty("xwikiPort", "8080");
    public static final String DEFAULT_STOPPORT = System.getProperty("xwikiStopPort", "8079");
    public static final String DEFAULT_RMIPORT = System.getProperty("rmiPort", "9010");
    private static final String DEFAULT_EXECUTION_DIRECTORY = System.getProperty("xwikiExecutionDirectory");
    private static final String START_COMMAND = System.getProperty("xwikiExecutionStartCommand");
    private static final String STOP_COMMAND = System.getProperty("xwikiExecutionStopCommand");
    private static final boolean DEBUG = System.getProperty("debug", "false").equalsIgnoreCase("true");
    private static final String WEBINF_PATH = "/webapps/xwiki/WEB-INF";
    private static final String XWIKICFG_PATH = "/webapps/xwiki/WEB-INF/xwiki.cfg";
    private static final String XWIKIPROPERTIES_PATH = "/webapps/xwiki/WEB-INF/xwiki.properties";
    private static final int TIMEOUT_SECONDS = 120;
    private Project project;
    private int port;
    private int stopPort;
    private int rmiPort;
    private String executionDirectory;
    private List<Environment.Variable> env = new ArrayList<Environment.Variable>();
    private String opts;
    private boolean wasStarted;

    public XWikiExecutor(int index) {
        this.project = new Project();
        this.project.init();
        this.project.addBuildListener((BuildListener)new AntBuildListener(DEBUG));
        String portString = System.getProperty("xwikiPort" + index);
        this.port = portString != null ? Integer.valueOf(portString) : Integer.valueOf(DEFAULT_PORT) + index;
        String stopPortString = System.getProperty("xwikiStopPort" + index);
        this.stopPort = stopPortString != null ? Integer.valueOf(stopPortString) : Integer.valueOf(DEFAULT_STOPPORT) - index;
        String rmiPortString = System.getProperty("rmiPort" + index);
        this.rmiPort = rmiPortString != null ? Integer.valueOf(rmiPortString) : Integer.valueOf(DEFAULT_RMIPORT) + index;
        this.executionDirectory = System.getProperty("xwikiExecutionDirectory" + index);
        if (this.executionDirectory == null) {
            this.executionDirectory = DEFAULT_EXECUTION_DIRECTORY;
            if (index > 0) {
                this.executionDirectory = this.executionDirectory + "-" + index;
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public String getExecutionDirectory() {
        if (this.executionDirectory == null) {
            throw new RuntimeException("Invalid configuration for the execution directory. The [xwikiExecutionDirectory] system property must be specified.");
        }
        return this.executionDirectory;
    }

    public void addEnvironmentVariable(String key, String value) {
        Environment.Variable variable = new Environment.Variable();
        variable.setKey(key);
        variable.setValue(value);
        this.env.add(variable);
    }

    public void setOpts(String opts) {
        this.opts = opts;
    }

    public void start() throws Exception {
        System.out.println("Starting XWiki server start");
        boolean bl = this.wasStarted = !this.isXWikiStarted((String)this.getURL(), (int)15).timedOut;
        if (!this.wasStarted) {
            this.startXWikiInSeparateThread();
            this.waitForXWikiToLoad();
        } else {
            System.out.println("XWiki server is already started!");
        }
    }

    private void startXWikiInSeparateThread() {
        Thread startThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    XWikiExecutor.this.startXWiki();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        startThread.start();
    }

    private void startXWiki() throws Exception {
        ExecTask execTask;
        File dir = new File(this.getExecutionDirectory());
        if (dir.exists()) {
            execTask = (ExecTask)this.project.createTask("exec");
            execTask.setDir(new File(this.getExecutionDirectory()));
            for (Environment.Variable variable : this.env) {
                execTask.addEnv(variable);
            }
            if (this.opts != null) {
                Environment.Variable optsVariable = new Environment.Variable();
                optsVariable.setKey("XWIKI_OPTS");
                optsVariable.setValue(this.opts);
                execTask.addEnv(optsVariable);
            }
        } else {
            throw new Exception("Invalid directory from where to start XWiki [" + this.executionDirectory + "]");
        }
        String startCommand = START_COMMAND;
        startCommand = startCommand.replaceFirst(DEFAULT_PORT, String.valueOf(this.getPort()));
        startCommand = startCommand.replaceFirst(DEFAULT_STOPPORT, String.valueOf(this.getStopPort()));
        startCommand = startCommand.replaceFirst(DEFAULT_RMIPORT, String.valueOf(this.getRMIPort()));
        Commandline commandLine = new Commandline(startCommand);
        execTask.setCommand(commandLine);
        execTask.execute();
    }

    private Task createStopTask() throws Exception {
        File dir = new File(this.getExecutionDirectory());
        if (!dir.exists()) {
            throw new Exception("Invalid directory from where to stop XWiki [" + this.executionDirectory + "]");
        }
        ExecTask execTask = (ExecTask)this.project.createTask("exec");
        execTask.setDir(new File(this.getExecutionDirectory()));
        String stopCommand = STOP_COMMAND;
        stopCommand = stopCommand.replaceFirst(DEFAULT_STOPPORT, String.valueOf(this.getStopPort()));
        Commandline commandLine = new Commandline(stopCommand);
        execTask.setCommand(commandLine);
        return execTask;
    }

    private void waitForXWikiToLoad() throws Exception {
        System.out.println("Checking that XWiki is up and running...");
        Response response = this.isXWikiStarted(this.getURL(), 120);
        if (response.timedOut) {
            String message = "Failed to start XWiki in [120] seconds, last error code [" + response.responseCode + ", message [" + new String(response.responseBody) + "]";
            System.out.println(message);
            this.stop();
            throw new RuntimeException(message);
        }
        System.out.println("Server is answering to [" + this.getURL() + "]... cool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response isXWikiStarted(String url, int timeout) throws Exception {
        HttpClient client = new HttpClient();
        boolean connected = false;
        long startTime = System.currentTimeMillis();
        Response response = new Response();
        response.timedOut = false;
        response.responseCode = -1;
        response.responseBody = new byte[0];
        while (!connected && !response.timedOut) {
            GetMethod method = new GetMethod(url);
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
            method.getParams().setParameter("http.socket.timeout", (Object)new Integer(10000));
            try {
                response.responseCode = client.executeMethod((HttpMethod)method);
                response.responseBody = method.getResponseBody();
                if (DEBUG) {
                    System.out.println("Result of pinging [" + url + "] = [" + response.responseCode + "], Message = [" + new String(response.responseBody) + "]");
                }
                connected = response.responseCode < 400 || response.responseCode == 401;
            }
            catch (Exception e) {
            }
            finally {
                method.releaseConnection();
            }
            Thread.sleep(500L);
            response.timedOut = System.currentTimeMillis() - startTime > (long)timeout * 1000L;
        }
        return response;
    }

    public void stop() throws Exception {
        if (!this.wasStarted) {
            this.createStopTask().execute();
        }
        System.out.println("XWiki server stopped");
    }

    public String getWebInfDirectory() {
        return this.getExecutionDirectory() + WEBINF_PATH;
    }

    public String getXWikiCfgPath() {
        return this.getExecutionDirectory() + XWIKICFG_PATH;
    }

    public String getXWikiPropertiesPath() {
        return this.getExecutionDirectory() + XWIKIPROPERTIES_PATH;
    }

    public Properties loadXWikiCfg() throws Exception {
        return this.getProperties(this.getXWikiCfgPath());
    }

    public Properties loadXWikiProperties() throws Exception {
        return this.getProperties(this.getXWikiPropertiesPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(String path) throws Exception {
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(path);
            try {
                properties.load(fis);
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Failed to load properties [" + path + "]", (Throwable)e);
        }
        return properties;
    }

    public void saveXWikiCfg(Properties properties) throws Exception {
        this.saveProperties(this.getXWikiCfgPath(), properties);
    }

    public void saveXWikiProperties(Properties properties) throws Exception {
        this.saveProperties(this.getXWikiPropertiesPath(), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties(String path, Properties properties) throws Exception {
        FileOutputStream fos = new FileOutputStream(path);
        try {
            properties.store(fos, null);
        }
        finally {
            fos.close();
        }
    }

    private String getURL() {
        return "http://localhost:" + this.getPort() + "/xwiki/bin/view/Main/WebHome";
    }

    private class Response {
        public boolean timedOut;
        public byte[] responseBody;
        public int responseCode;

        private Response() {
        }
    }
}

