/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor.wysiwyg;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.editor.wysiwyg.AttachedImageSelectPane;
import org.xwiki.test.ui.po.editor.wysiwyg.TableConfigPane;

public class MenuBarElement
extends BaseElement {
    private static final String MENU_ITEM_XPATH = "//td[contains(@class, 'gwt-MenuItem') and . = '%s']";
    private final WebElement container;

    public MenuBarElement(WebElement container) {
        this.container = container;
    }

    public void clickImageMenu() {
        this.clickMenuWithLabel("Image");
    }

    public void clickTableMenu() {
        this.clickMenuWithLabel("Table");
    }

    public AttachedImageSelectPane clickInsertAttachedImageMenu() {
        String xpath = String.format(MENU_ITEM_XPATH, "Attached Image...");
        WebElement insertAttachedImageMenu = this.container.findElement(By.xpath((String)xpath));
        if (!this.isMenuEnabled(insertAttachedImageMenu)) {
            return null;
        }
        insertAttachedImageMenu.click();
        return new AttachedImageSelectPane().waitToLoad();
    }

    public TableConfigPane clickInsertTableMenu() {
        String xpath = String.format(MENU_ITEM_XPATH, "Insert Table...");
        WebElement insertTableMenu = this.container.findElement(By.xpath((String)xpath));
        if (!this.isMenuEnabled(insertTableMenu)) {
            return null;
        }
        insertTableMenu.click();
        return new TableConfigPane().waitToLoad();
    }

    private boolean isMenuEnabled(WebElement menu) {
        return !menu.getAttribute("class").contains("gwt-MenuItem-disabled");
    }

    private void clickMenuWithLabel(String label) {
        this.container.findElement(By.xpath((String)String.format(MENU_ITEM_XPATH, label))).click();
    }
}

