/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import com.google.code.tempusfugit.concurrency.IntermittentTestRunner;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatchman;
import org.junit.runner.RunWith;
import org.junit.runners.model.FrameworkMethod;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.test.ui.PersistentTestContext;
import org.xwiki.test.ui.TestUtils;
import org.xwiki.test.ui.browser.BrowserMethodRule;
import org.xwiki.test.ui.po.BaseElement;

@RunWith(value=IntermittentTestRunner.class)
public class AbstractTest {
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public BrowserMethodRule browseMethodRule = new BrowserMethodRule(AbstractTest.getDriver());
    @Rule
    public final MethodRule watchman = new TestWatchman(){

        public void starting(FrameworkMethod method) {
            AbstractTest.this.logger.info("{} started", (Object)method.getName());
        }

        public void succeeded(FrameworkMethod method) {
            AbstractTest.this.logger.info("{} succeeded", (Object)method.getName());
        }

        public void failed(Throwable e, FrameworkMethod method) {
            AbstractTest.this.logger.info("{} failed", (Object)method.getName());
        }
    };
    protected static PersistentTestContext context;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void setContext(PersistentTestContext context) {
        AbstractTest.context = context;
        BaseElement.setContext(context);
        TestUtils.setContext(context);
        AbstractTest.getUtil().recacheSecretToken();
    }

    @Before
    public void setTestName() {
        context.setCurrentTestName(this.getClass().getSimpleName() + "-" + this.getTestMethodName());
    }

    @BeforeClass
    public static void init() throws Exception {
        if (context == null) {
            AbstractTest.setContext(new PersistentTestContext());
        }
    }

    @AfterClass
    public static void shutdown() throws Exception {
        context.shutdown();
    }

    protected String getTestMethodName() {
        return this.testName.getMethodName();
    }

    protected String getTestClassName() {
        return this.getClass().getSimpleName();
    }

    protected static WebDriver getDriver() {
        return context.getDriver();
    }

    protected static TestUtils getUtil() {
        return context.getUtil();
    }
}

