/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.xwiki.test.integration.XWikiExecutorSuite;
import org.xwiki.test.ui.AbstractTest;
import org.xwiki.test.ui.PersistentTestContext;

public class PageObjectSuite
extends XWikiExecutorSuite {
    private PersistentTestContext context;

    public PageObjectSuite(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError {
        super(suiteClass, builder);
    }

    @Override
    protected void beforeTests() {
        super.beforeTests();
        try {
            this.context = new PersistentTestContext(this.getExecutors().get(0));
            AbstractTest.setContext(this.context.getUnstoppable());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize PersistentTestContext", e);
        }
        try {
            for (Method method : this.getTestClass().getJavaClass().getMethods()) {
                PostStart postStartAnnotation = method.getAnnotation(PostStart.class);
                if (postStartAnnotation == null) continue;
                Object instance = this.getTestClass().getJavaClass().newInstance();
                method.invoke(instance, this.context);
            }
        }
        catch (Exception e) {
            this.afterTests();
            throw new RuntimeException("Failed to initialize PO suite", e);
        }
    }

    @Override
    protected void afterTests() {
        try {
            this.context.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to shutdown PersistentTestContext", e);
        }
        super.afterTests();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PostStart {
    }
}

