/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.integration;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.extensions.cpsuite.ClasspathSuite;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.xwiki.test.integration.XWikiExecutor;

public class XWikiExecutorSuite
extends ClasspathSuite {
    public static final String PATTERN = ".*" + System.getProperty("pattern", "");
    private List<XWikiExecutor> executors = new ArrayList<XWikiExecutor>();

    public XWikiExecutorSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, builder);
    }

    public List<XWikiExecutor> getExecutors() {
        return this.executors;
    }

    protected List<Runner> getChildren() {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        for (Runner runner : super.getChildren()) {
            if (!runner.getDescription().getClassName().matches(PATTERN)) continue;
            runners.add(runner);
        }
        return runners;
    }

    protected void beforeTests() {
        Object instance;
        int executorNb = 1;
        Executors executorsAnnotation = this.getTestClass().getJavaClass().getAnnotation(Executors.class);
        if (executorsAnnotation != null) {
            executorNb = executorsAnnotation.value();
        }
        for (int i = 0; i < executorNb; ++i) {
            this.executors.add(new XWikiExecutor(i));
        }
        try {
            for (Method method : this.getTestClass().getJavaClass().getMethods()) {
                PreStart preStartAnnotation = method.getAnnotation(PreStart.class);
                if (preStartAnnotation == null) continue;
                instance = this.getTestClass().getJavaClass().newInstance();
                method.invoke(instance, this.executors);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XWiki Executors before start", e);
        }
        try {
            for (XWikiExecutor executor : this.executors) {
                executor.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start XWiki", e);
        }
        try {
            for (Method method : this.getTestClass().getJavaClass().getMethods()) {
                PostStart postStartAnnotation = method.getAnnotation(PostStart.class);
                if (postStartAnnotation == null) continue;
                instance = this.getTestClass().getJavaClass().newInstance();
                method.invoke(instance, this.executors);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XWiki Executors after start", e);
        }
    }

    protected void afterTests() {
        try {
            for (XWikiExecutor executor : this.executors) {
                executor.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop XWiki", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        this.beforeTests();
        try {
            super.run(notifier);
        }
        finally {
            this.afterTests();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PostStart {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PreStart {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Executors {
        public int value() default 1;
    }
}

