/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.xwiki.test.ui.po.FormElement;
import org.xwiki.test.ui.po.editor.EditPage;

public class ObjectEditPage
extends EditPage {
    @FindBy(id="update")
    private WebElement objectForm;
    @FindBy(id="classname")
    private WebElement classNameField;
    @FindBy(name="action_objectadd")
    private WebElement classNameSubmit;
    private FormElement form;

    public static ObjectEditPage gotoPage(String space, String page) {
        ObjectEditPage.getUtil().gotoPage(space, page, "edit", "editor=object");
        return new ObjectEditPage();
    }

    public FormElement addObject(String className) {
        this.getForm().setFieldValue(this.classNameField, className);
        final By objectsLocator = By.cssSelector((String)("[id='xclass_" + className + "'] .xobject"));
        final int initialObjectCount = ObjectEditPage.getUtil().findElementsWithoutWaiting(this.getDriver(), objectsLocator).size();
        this.classNameSubmit.click();
        ObjectEditPage.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return driver.findElements(objectsLocator).size() > initialObjectCount;
            }
        });
        List<FormElement> objects = this.getObjectsOfClass(className);
        return objects.get(objects.size() - 1);
    }

    public FormElement addObjectFromInlineLink(String className) {
        final By objectsLocator = By.cssSelector((String)("[id='xclass_" + className + "'] .xobject"));
        final int initialObjectCount = this.getDriver().findElements(objectsLocator).size();
        this.getDriver().findElement(By.cssSelector((String)("[id='add_xobject_" + className + "'] .xobject-add-control"))).click();
        ObjectEditPage.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return driver.findElements(objectsLocator).size() > initialObjectCount;
            }
        });
        List<FormElement> objects = this.getObjectsOfClass(className);
        return objects.get(objects.size() - 1);
    }

    public void removeAllObjects(String className) {
        List<WebElement> objectContainers = ObjectEditPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)("//div[starts-with(@id, 'xobject_" + className + "_')]")));
        ArrayList<WebElement> validElements = new ArrayList<WebElement>();
        for (WebElement element : objectContainers) {
            String id = element.getAttribute("id");
            if (id.endsWith("_content") || id.endsWith("_title")) continue;
            validElements.add(element);
        }
        for (WebElement element : validElements) {
            this.deleteObject(By.id((String)element.getAttribute("id")));
        }
    }

    public void deleteObject(String className, int index) {
        this.deleteObject(By.id((String)("xobject_" + className + "_" + index)));
    }

    public void deleteObject(By objectLocator) {
        WebElement objectContainer = this.getDriver().findElement(objectLocator);
        WebElement deleteLink = objectContainer.findElement(By.className((String)"delete"));
        deleteLink.click();
        this.waitUntilElementIsVisible(By.className((String)"xdialog-box-confirmation"));
        this.getDriver().findElement(By.cssSelector((String)".xdialog-box-confirmation input[value='Yes']")).click();
        this.waitUntilElementDisappears(objectLocator);
    }

    public void removeAllDeprecatedProperties() {
        this.getDriver().findElement(By.className((String)"syncAllProperties")).click();
        this.waitUntilElementDisappears(By.className((String)"deprecatedProperties"));
    }

    public boolean isPropertyDeprecated(String className, String propertyName) {
        WebElement xclass = this.getDriver().findElement(By.id((String)("xclass_" + className)));
        List deprecatedPropertiesElements = xclass.findElements(By.className((String)"deprecatedProperties"));
        if (deprecatedPropertiesElements.size() > 0) {
            String xpath = "//label[. = '" + propertyName + ":']";
            return ((WebElement)deprecatedPropertiesElements.get(0)).findElements(By.xpath((String)xpath)).size() > 0;
        }
        return false;
    }

    private FormElement getForm() {
        if (this.form == null) {
            this.form = new FormElement(this.objectForm);
        }
        return this.form;
    }

    public String getURL(String space, String page) {
        return ObjectEditPage.getUtil().getURL(space, page, "edit", "editor=object");
    }

    public List<FormElement> getObjectsOfClass(String className) {
        List titles = this.getDriver().findElement(By.id((String)("xclass_" + className))).findElements(By.className((String)"xobject-title"));
        List elements = this.getDriver().findElement(By.id((String)("xclass_" + className))).findElements(By.className((String)"xobject-content"));
        ArrayList<FormElement> forms = new ArrayList<FormElement>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            WebElement element = (WebElement)elements.get(i);
            if (!element.isDisplayed()) {
                ((WebElement)titles.get(i)).click();
            }
            forms.add(new FormElement(element));
        }
        return forms;
    }
}

