/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor.wysiwyg;

import org.openqa.selenium.By;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.editor.wysiwyg.MenuBarElement;
import org.xwiki.test.ui.po.editor.wysiwyg.RichTextAreaElement;
import org.xwiki.test.ui.po.editor.wysiwyg.ToolBarElement;

public class EditorElement
extends BaseElement {
    private static final String TAB_ITEM_XPATH = "//div[@role = 'tab' and . = '%s']";
    private final String fieldId;
    private MenuBarElement menuBar;
    private ToolBarElement toolBar;

    public EditorElement(String fieldId) {
        this.fieldId = fieldId;
    }

    public MenuBarElement getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new MenuBarElement(this.getContainer().findElement(By.className((String)"gwt-MenuBar-horizontal")));
        }
        return this.menuBar;
    }

    public ToolBarElement getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new ToolBarElement(this.getContainer().findElement(By.className((String)"xToolbar")));
        }
        return this.toolBar;
    }

    public RichTextAreaElement getRichTextArea() {
        return new RichTextAreaElement(this.getContainer().findElement(By.className((String)"gwt-RichTextArea")));
    }

    public WebElement getSourceTextArea() {
        return this.getContainer().findElement(By.className((String)"xPlainTextEditor"));
    }

    public EditorElement waitToLoad() {
        EditorElement.getUtil().waitUntilCondition(new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                try {
                    EditorElement.this.getContainer(driver).findElement(By.xpath((String)"//div[@class = 'gwt-TabBarItem gwt-TabBarItem-selected']/div[. = 'Source']"));
                    WebElement sourceTextArea = EditorElement.this.getContainer(driver).findElement(By.className((String)"xPlainTextEditor"));
                    return sourceTextArea.isEnabled() ? sourceTextArea : null;
                }
                catch (NotFoundException sourceNotFound) {
                    WebElement richTextEditor = EditorElement.this.getContainer(driver).findElement(By.className((String)"xRichTextEditor"));
                    try {
                        richTextEditor.findElement(By.className((String)"loading"));
                        return null;
                    }
                    catch (NotFoundException loadingNotFound) {
                        return richTextEditor;
                    }
                }
            }
        });
        return this;
    }

    public void switchToSource() {
        this.switchToSource(true);
    }

    public void switchToSource(boolean wait) {
        this.getContainer().findElement(By.xpath((String)String.format(TAB_ITEM_XPATH, "Source"))).click();
        if (wait) {
            this.waitForSourceTextArea(true);
        }
    }

    public void switchToWysiwyg() {
        this.switchToWysiwyg(true);
    }

    public void switchToWysiwyg(boolean wait) {
        this.getContainer().findElement(By.xpath((String)String.format(TAB_ITEM_XPATH, "WYSIWYG"))).click();
        if (wait) {
            this.waitForSourceTextArea(false);
        }
    }

    private void waitForSourceTextArea(final boolean enabled) {
        EditorElement.getUtil().waitUntilCondition(new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement sourceTextArea = EditorElement.this.getContainer().findElement(By.className((String)"xPlainTextEditor"));
                return sourceTextArea.isEnabled() == enabled ? sourceTextArea : null;
            }
        });
    }

    private WebElement getContainer(WebDriver driver) {
        return driver.findElement(By.xpath((String)("//div[starts-with(@id, '" + this.fieldId + "_container')]")));
    }

    protected WebElement getContainer() {
        return this.getContainer(this.getDriver());
    }
}

