/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;

public class AttachmentsPane
extends BaseElement {
    @FindBy(id="Attachmentspane")
    private WebElement pane;
    @FindBy(xpath="//input[@value='Add another file']")
    private WebElement addAnotherFile;

    public void setFileToUpload(String filePath) {
        List inputs = this.pane.findElements(By.className((String)"uploadFileInput"));
        ((WebElement)inputs.get(inputs.size() - 1)).sendKeys(new CharSequence[]{filePath});
    }

    public void waitForUploadToFinish(String fileName) {
        this.waitForNotificationSuccessMessage("Attachment uploaded: " + fileName);
    }

    public void clickHideProgress() {
        this.pane.findElement(By.xpath((String)"//a[text()='Hide upload status']")).click();
    }

    public void addAnotherFile() {
        this.addAnotherFile.click();
    }

    public void clickAttachFiles() {
        this.pane.findElement(By.xpath((String)"//form[@id='AddAttachment']//input[@class='button' and @type='submit' and @value='Attach']")).click();
    }

    public WebElement getAttachmentLink(String attachmentName) {
        return this.getDriver().findElement(By.xpath((String)("//div[@id='_attachments']//a[@title = 'Download this attachment' and contains(@href, '" + attachmentName + "')]")));
    }

    public void deleteAttachmentByFileByName(String attachmentName) {
        this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../span[2]/a[@class='deletelink']"))).click();
        this.getDriver().findElement(By.xpath((String)"//*[@class='xdialog-modal-container']//input[@value='Yes']")).click();
        this.waitUntilElementDisappears(By.xpath((String)"//*[@class='xdialog-modal-container']/*[contains(@class, 'xdialog-box-confirmation')]"));
        this.waitUntilElementDisappears(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']")));
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='Attachmentspane']"));
    }

    public void deleteFirstAttachment() {
        String tmp = this.getDriver().findElement(By.xpath((String)"//div[@id='_attachments']/*[1]/div[@class='information']/span[@class='name']")).getText();
        this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + tmp + "']/../../span[2]/a[@class='deletelink']"))).click();
        this.getDriver().findElement(By.xpath((String)"//*[@class='xdialog-modal-container']//input[@value='Yes']")).click();
        this.waitUntilElementDisappears(By.xpath((String)"//*[@class='xdialog-modal-container']/*[contains(@class, 'xdialog-box-confirmation')]"));
        this.waitUntilElementDisappears(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + tmp + "']/../../span[2]/a[@class='deletelink']")));
    }

    public int getNumberOfAttachments() {
        By countLocator = By.cssSelector((String)"#Attachmentstab .itemCount");
        return Integer.parseInt(this.getDriver().findElement(countLocator).getText().replaceAll("[()]", ""));
    }

    public void deleteAllAttachments() {
        while (this.getNumberOfAttachments() > 0) {
            this.deleteFirstAttachment();
        }
    }

    public String getUploaderOfAttachment(String attachmentName) {
        return this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../div[@class='meta']/span[@class='publisher']/span[@class='wikilink']"))).toString();
    }

    public String getLatestVersionOfAttachment(String attachmentName) {
        return this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()= '" + attachmentName + "']/../../span[3]/a"))).getText();
    }

    public String getSizeOfAttachment(String attachmentName) {
        return this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../div[@class='meta']/span[@class='size']"))).toString().replaceAll("[()]", "");
    }

    public String getDateOfLastUpload(String attachmentName) {
        return this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../div[@class='meta']/span[@class='date']"))).toString().replaceFirst("on", "");
    }

    public boolean attachmentExistsByFileName(String attachmentName) {
        try {
            this.getDriver().findElement(By.xpath((String)("//a[@title = 'Download this attachment' and . = '" + attachmentName + "']")));
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }
}

