/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.test.ui.po.BaseElement;

public class FormElement
extends BaseElement {
    private final WebElement form;

    public FormElement(WebElement form) {
        this.form = form;
    }

    public void fillFieldsByName(Map<String, String> valuesByNames) {
        HashMap<WebElement, String> valuesByElements = new HashMap<WebElement, String>((int)((double)valuesByNames.size() / 0.75));
        for (String name : valuesByNames.keySet()) {
            valuesByElements.put(this.form.findElement(By.name((String)name)), valuesByNames.get(name));
        }
        this.fillFieldsByElements(valuesByElements);
    }

    public void fillFieldsByElements(Map<WebElement, String> valuesByElements) {
        for (WebElement el : valuesByElements.keySet()) {
            try {
                this.setFieldValue(el, valuesByElements.get(el));
            }
            catch (Exception e) {
                throw new WebDriverException("Couldn't set field \"" + el.getAttribute("name") + "\" to value \"" + valuesByElements.get(el) + "\"", (Throwable)e);
            }
        }
    }

    public String getFieldValue(By findElementBy) {
        return this.form.findElement(findElementBy).getAttribute("value");
    }

    public void setFieldValue(By findElementBy, String value) {
        this.setFieldValue(this.form.findElement(findElementBy), value);
    }

    public void setFieldValue(WebElement fieldElement, String value) {
        if ("checkbox".equals(fieldElement.getAttribute("type"))) {
            this.setCheckBox(fieldElement, value.equals("true"));
        } else if ("select".equals(fieldElement.getTagName())) {
            Select select = new Select(fieldElement);
            select.selectByValue(value);
        } else {
            fieldElement.clear();
            fieldElement.sendKeys(new CharSequence[]{value});
        }
    }

    public void setCheckBox(By findElementBy, boolean checked) {
        this.setCheckBox(this.form.findElement(findElementBy), checked);
    }

    public void setCheckBox(WebElement checkBoxElement, boolean checked) {
        int x = 0;
        while (checkBoxElement.isSelected() != checked) {
            checkBoxElement.click();
            if (x == 100) {
                throw new WebDriverException("Unable to set checkbox at " + checkBoxElement.getAttribute("name") + " to " + checked);
            }
            ++x;
        }
    }

    public SelectElement getSelectElement(By by) {
        return new SelectElement(this.form.findElement(by));
    }

    public class SelectElement
    extends BaseElement {
        private final WebElement select;
        private Map<String, WebElement> optionsByValue;

        public SelectElement(WebElement select) {
            if (!select.getTagName().toLowerCase().equals("select")) {
                throw new WebDriverException("Can only create a select element from a webelement of tag name select.");
            }
            this.select = select;
        }

        public Set<String> getOptions() {
            return this.getOptionsByValue().keySet();
        }

        private Map<String, WebElement> getOptionsByValue() {
            if (this.optionsByValue != null) {
                return this.optionsByValue;
            }
            List elements = this.select.findElements(By.tagName((String)"option"));
            this.optionsByValue = new HashMap<String, WebElement>((int)((double)elements.size() / 0.75));
            for (WebElement el : elements) {
                this.optionsByValue.put(el.getAttribute("value"), el);
            }
            return this.optionsByValue;
        }

        public void select(List<String> valuesToSelect) {
            if (valuesToSelect.size() > 1 && this.select.getAttribute("multiple") != "multiple") {
                throw new WebDriverException("Cannot select multiple elements in drop down menu.");
            }
            Map<String, WebElement> optionsByValue = this.getOptionsByValue();
            if (!optionsByValue.keySet().containsAll(valuesToSelect)) {
                throw new WebDriverException("Select Element(s): " + optionsByValue.keySet().retainAll(valuesToSelect) + " not found.");
            }
            for (String label : valuesToSelect) {
                optionsByValue.get(label).click();
            }
        }

        public void select(final String value) {
            this.select((List<String>)new ArrayList<String>(){
                {
                    this.add(value);
                }
            });
        }

        public void unSelect(List<String> valuesToUnSelect) {
            Map<String, WebElement> optionsByValue = this.getOptionsByValue();
            if (!optionsByValue.keySet().containsAll(valuesToUnSelect)) {
                throw new WebDriverException("Select Element(s) to unselect: " + optionsByValue.keySet().retainAll(valuesToUnSelect) + " not found.");
            }
            for (String label : valuesToUnSelect) {
                if (!optionsByValue.get(label).isSelected()) continue;
                optionsByValue.get(label).click();
            }
        }

        public void unSelect(final String value) {
            this.unSelect((List<String>)new ArrayList<String>(){
                {
                    this.add(value);
                }
            });
        }
    }
}

