/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.editor.PreviewableEditPage;

public class WikiEditPage
extends PreviewableEditPage {
    @FindBy(id="xwikidoctitleinput")
    private WebElement titleInput;
    @FindBy(name="parent")
    private WebElement parentInput;
    @FindBy(id="editParentTrigger")
    private WebElement editParentTrigger;
    @FindBy(id="content")
    private WebElement contentText;
    @FindBy(name="minorEdit")
    private WebElement minorEditCheckBox;
    @FindBy(name="comment")
    private WebElement commentInput;

    public static WikiEditPage gotoPage(String space, String page) {
        WikiEditPage.getUtil().gotoPage(space, page, "edit", "editor=wiki");
        return new WikiEditPage();
    }

    public String getTitle() {
        return this.titleInput.getAttribute("value");
    }

    public void setTitle(String title) {
        this.titleInput.clear();
        this.titleInput.sendKeys(new CharSequence[]{title});
    }

    public String getParent() {
        return this.parentInput.getAttribute("value");
    }

    public void setParent(String parent) {
        this.parentInput = this.getDriver().findElement(By.name((String)"parent"));
        if (!this.parentInput.isDisplayed()) {
            this.editParentTrigger.click();
        }
        this.parentInput.clear();
        this.parentInput.sendKeys(new CharSequence[]{parent});
    }

    public String getContent() {
        return this.contentText.getText();
    }

    public void setContent(String content) {
        this.contentText.clear();
        this.contentText.sendKeys(new CharSequence[]{content});
    }

    public void setMinorEdit(boolean value) {
        if (this.minorEditCheckBox.isSelected() && !value || !this.minorEditCheckBox.isSelected() && value) {
            this.minorEditCheckBox.click();
        }
    }

    public void setEditComment(String comment) {
        this.commentInput.clear();
        this.commentInput.sendKeys(new CharSequence[]{comment});
    }
}

