/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor;

import org.openqa.selenium.By;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.FormElement;

public class ClassPropertyEditPane
extends BaseElement {
    private final FormElement form;
    private final String propertyName;

    public ClassPropertyEditPane(FormElement form, String propertyName) {
        this.form = form;
        this.propertyName = propertyName;
    }

    public ClassPropertyEditPane expand() {
        By containerLocator = By.id((String)("xproperty_" + this.propertyName));
        By titleLocator = By.id((String)("xproperty_" + this.propertyName + "_title"));
        this.waitUntilElementIsVisible(containerLocator);
        if (ClassPropertyEditPane.getUtil().findElementWithoutWaiting(this.getDriver(), containerLocator).getAttribute("class").contains("collapsed")) {
            ClassPropertyEditPane.getUtil().findElementWithoutWaiting(this.getDriver(), titleLocator).click();
        }
        return this;
    }

    protected ClassPropertyEditPane setMetaProperty(String metaPropertyName, String value) {
        this.form.setFieldValue(By.id((String)(this.propertyName + "_" + metaPropertyName)), value);
        return this;
    }

    public ClassPropertyEditPane setPrettyName(String prettyName) {
        return this.setMetaProperty("prettyName", prettyName);
    }
}

