/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.xwiki.test.ui.TestUtils;

public class AuthenticationRule
implements MethodRule {
    private String userName;
    private String userPassword;
    private TestUtils testUtils;
    private WebDriver driver;

    public AuthenticationRule(String userName, String userPassword, TestUtils testUtils, WebDriver driver) {
        this.userName = userName;
        this.userPassword = userPassword;
        this.testUtils = testUtils;
        this.driver = driver;
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                AuthenticationRule.this.authenticate();
                base.evaluate();
            }
        };
    }

    public void authenticate() {
        if (!this.userName.equals(this.testUtils.getLoggedInUserName())) {
            this.driver.get(this.testUtils.getURLToLoginAndGotoPage(this.userName, this.userPassword, this.testUtils.getURLToNonExistentPage()));
            this.testUtils.recacheSecretToken();
        }
    }
}

