/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Xwiki;
import org.xwiki.test.integration.XWikiExecutor;
import org.xwiki.test.ui.PersistentTestContext;
import org.xwiki.test.ui.po.ViewPage;
import org.xwiki.test.ui.po.editor.ClassEditPage;
import org.xwiki.test.ui.po.editor.ObjectEditPage;

public class TestUtils {
    public static final UsernamePasswordCredentials ADMIN_CREDENTIALS = new UsernamePasswordCredentials("Admin", "admin");
    public static final UsernamePasswordCredentials SUPER_ADMIN_CREDENTIALS = new UsernamePasswordCredentials("superadmin", "pass");
    public static final String BASE_URL = XWikiExecutor.URL + ":" + XWikiExecutor.DEFAULT_PORT + "/xwiki/";
    public static final String BASE_BIN_URL = BASE_URL + "bin/";
    public static final String BASE_REST_URL = BASE_URL + "rest/";
    private static PersistentTestContext context;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private static ObjectFactory objectFactory;
    private int timeout;
    private String secretToken;
    private HttpClient adminHTTPClient;

    public TestUtils() {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.xwiki.rest.model.jaxb:org.xwiki.extension.repository.xwiki.model.jaxb");
            marshaller = context.createMarshaller();
            unmarshaller = context.createUnmarshaller();
            objectFactory = new ObjectFactory();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        this.timeout = 10;
        this.secretToken = null;
        this.adminHTTPClient = new HttpClient();
        this.adminHTTPClient.getState().setCredentials(AuthScope.ANY, (Credentials)ADMIN_CREDENTIALS);
        this.adminHTTPClient.getParams().setAuthenticationPreemptive(true);
    }

    public static void setContext(PersistentTestContext context) {
        TestUtils.context = context;
    }

    protected WebDriver getDriver() {
        return context.getDriver();
    }

    public Session getSession() {
        return new Session(this.getDriver().manage().getCookies(), this.getSecretToken());
    }

    public void setSession(Session session) {
        WebDriver.Options options = this.getDriver().manage();
        options.deleteAllCookies();
        if (session != null) {
            for (Cookie cookie : session.getCookies()) {
                options.addCookie(cookie);
            }
        }
        if (session != null && !StringUtils.isEmpty((String)session.getSecretToken())) {
            this.secretToken = session.getSecretToken();
        } else {
            this.recacheSecretToken();
        }
    }

    public String getURLToLogout() {
        return this.getURL("XWiki", "XWikiLogin", "logout");
    }

    public String getURLToLoginAsAdmin() {
        return this.getURLToLoginAs(ADMIN_CREDENTIALS.getUserName(), ADMIN_CREDENTIALS.getPassword());
    }

    public String getURLToLoginAsSuperAdmin() {
        return this.getURLToLoginAs(SUPER_ADMIN_CREDENTIALS.getUserName(), SUPER_ADMIN_CREDENTIALS.getPassword());
    }

    public String getURLToLoginAs(String username, String password) {
        return this.getURLToLoginAndGotoPage(username, password, null);
    }

    public String getURLToLoginAsAdminAndGotoPage(String pageURL) {
        return this.getURLToLoginAndGotoPage(ADMIN_CREDENTIALS.getUserName(), ADMIN_CREDENTIALS.getPassword(), pageURL);
    }

    public String getURLToLoginAsSuperAdminAndGotoPage(String pageURL) {
        return this.getURLToLoginAndGotoPage(SUPER_ADMIN_CREDENTIALS.getUserName(), SUPER_ADMIN_CREDENTIALS.getPassword(), pageURL);
    }

    public String getURLToLoginAndGotoPage(final String username, final String password, final String pageURL) {
        HashMap<String, String> parameters = new HashMap<String, String>(){
            {
                this.put("j_username", username);
                this.put("j_password", password);
                if (pageURL != null && pageURL.length() > 0) {
                    this.put("xredirect", pageURL);
                }
            }
        };
        return this.getURL("XWiki", "XWikiLogin", "loginsubmit", parameters);
    }

    public String getURLToNonExistentPage() {
        return this.getURL("NonExistentSpace", "NonExistentPage", "view", "xpage=plain");
    }

    public void assertOnPage(String pageURL) {
        final String pageURI = pageURL.replaceAll("\\?.*", "");
        this.waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return TestUtils.this.getDriver().getCurrentUrl().contains(pageURI);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void waitUntilCondition(ExpectedCondition<T> condition) {
        this.getDriver().manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        WebDriverWait wait = new WebDriverWait(this.getDriver(), (long)this.getTimeout());
        try {
            wait.until(condition);
        }
        finally {
            this.setDriverImplicitWait(this.getDriver());
        }
    }

    public String getLoggedInUserName() {
        String loggedInUserName = null;
        List<WebElement> elements = this.findElementsWithoutWaiting(this.getDriver(), By.xpath((String)"//div[@id='tmUser']/span/a"));
        if (!elements.isEmpty()) {
            String href = elements.get(0).getAttribute("href");
            loggedInUserName = href.substring(href.lastIndexOf("/") + 1);
        }
        return loggedInUserName;
    }

    public void createUserAndLogin(String username, String password, Object ... properties) {
        this.createUserAndLoginWithRedirect(username, password, this.getURLToNonExistentPage(), properties);
    }

    public void createUserAndLoginWithRedirect(String username, String password, String url, Object ... properties) {
        this.createUser(username, password, this.getURLToLoginAndGotoPage(username, password, url), properties);
    }

    public void createUser(String username, String password, String redirectURL, Object ... properties) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("register", "1");
        parameters.put("xwikiname", username);
        parameters.put("register_password", password);
        parameters.put("register2_password", password);
        parameters.put("register_email", "");
        parameters.put("xredirect", redirectURL);
        parameters.put("form_token", this.getSecretToken());
        this.getDriver().get(this.getURL("XWiki", "Register", "register", parameters));
        this.recacheSecretToken();
        if (properties.length > 0) {
            this.updateObject("XWiki", username, "XWiki.XWikiUsers", 0, properties);
        }
    }

    @Deprecated
    public void registerLoginAndGotoPage(String username, String password, String pageURL) {
        this.createUserAndLogin(username, password, new Object[0]);
        this.getDriver().get(pageURL);
    }

    public ViewPage gotoPage(String space, String page) {
        this.gotoPage(space, page, "view");
        return new ViewPage();
    }

    public void gotoPage(String space, String page, String action) {
        this.gotoPage(space, page, action, "");
    }

    public void gotoPage(String space, String page, String action, Object ... queryParameters) {
        this.gotoPage(space, page, action, this.toQueryString(queryParameters));
    }

    public void gotoPage(String space, String page, String action, Map<String, ?> queryParameters) {
        this.gotoPage(space, page, action, this.toQueryString(queryParameters));
    }

    public void gotoPage(String space, String page, String action, String queryString) {
        this.gotoPage(this.getURL(space, page, action, queryString));
    }

    public void gotoPage(String url) {
        if (!this.getDriver().getCurrentUrl().equals(url)) {
            this.getDriver().get(url);
        }
    }

    public String getURLToDeletePage(String space, String page) {
        return this.getURL(space, page, "delete", "confirm=1");
    }

    public String getURLToDeleteSpace(String space) {
        return this.getURL(space, "WebHome", "deletespace", "confirm=1");
    }

    public ViewPage createPage(String space, String page, String content, String title) {
        return this.createPage(space, page, content, title, null);
    }

    public ViewPage createPage(String space, String page, String content, String title, String syntaxId) {
        return this.createPage(space, page, content, title, syntaxId, null);
    }

    public ViewPage createPage(String space, String page, String content, String title, String syntaxId, String parentFullPageName) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (content != null) {
            queryMap.put("content", content);
        }
        if (title != null) {
            queryMap.put("title", title);
        }
        if (syntaxId != null) {
            queryMap.put("syntaxId", syntaxId);
        }
        if (parentFullPageName != null) {
            queryMap.put("parent", parentFullPageName);
        }
        this.gotoPage(space, page, "save", queryMap);
        return new ViewPage();
    }

    public ViewPage createPageWithAttachment(String space, String page, String content, String title, String syntaxId, String parentFullPageName, String attachmentName, InputStream attachmentData) throws Exception {
        return this.createPageWithAttachment(space, page, content, title, syntaxId, parentFullPageName, attachmentName, attachmentData, null);
    }

    public ViewPage createPageWithAttachment(String space, String page, String content, String title, String syntaxId, String parentFullPageName, String attachmentName, InputStream attachmentData, UsernamePasswordCredentials credentials) throws Exception {
        ViewPage vp = this.createPage(space, page, content, title, syntaxId, parentFullPageName);
        this.attachFile(space, page, attachmentName, attachmentData, false, credentials);
        return vp;
    }

    public ViewPage createPageWithAttachment(String space, String page, String content, String title, String attachmentName, InputStream attachmentData) throws Exception {
        return this.createPageWithAttachment(space, page, content, title, null, null, attachmentName, attachmentData);
    }

    public ViewPage createPageWithAttachment(String space, String page, String content, String title, String attachmentName, InputStream attachmentData, UsernamePasswordCredentials credentials) throws Exception {
        ViewPage vp = this.createPage(space, page, content, title);
        this.attachFile(space, page, attachmentName, attachmentData, false, credentials);
        return vp;
    }

    public void deletePage(String space, String page) {
        this.getDriver().get(this.getURLToDeletePage(space, page));
    }

    public void deleteSpace(String space) {
        this.getDriver().get(this.getURLToDeleteSpace(space));
    }

    public boolean pageExists(String space, String page) {
        boolean exists;
        try {
            this.executeGet(this.getURL(space, page), Response.Status.OK.getStatusCode());
            exists = true;
        }
        catch (Exception e) {
            exists = false;
        }
        return exists;
    }

    public String getURL(String space, String page) {
        return this.getURL(space, page, "view");
    }

    public String getURL(String space, String page, String action) {
        return this.getURL(space, page, action, "");
    }

    public String getURL(String space, String page, String action, String queryString) {
        return this.getURL(new String[]{space, page}, action, queryString);
    }

    private String getURL(String[] path, String action, String queryString) {
        boolean needToAddSecretToken;
        StringBuilder builder = new StringBuilder(BASE_BIN_URL);
        builder.append(action);
        for (int i = 0; i < path.length; ++i) {
            builder.append('/').append(this.escapeURL(path[i]));
        }
        boolean bl = needToAddSecretToken = !Arrays.asList("view", "register", "download").contains(action);
        if (needToAddSecretToken || !StringUtils.isEmpty((String)queryString)) {
            builder.append('?');
        }
        if (needToAddSecretToken) {
            this.addQueryStringEntry(builder, "form_token", this.getSecretToken());
            builder.append('&');
        }
        if (!StringUtils.isEmpty((String)queryString)) {
            builder.append(queryString);
        }
        return builder.toString();
    }

    public String getURL(String space, String page, String action, Map<String, ?> queryParameters) {
        return this.getURL(space, page, action, this.toQueryString(queryParameters));
    }

    public String getAttachmentURL(String space, String page, String attachment, String action, String queryString) {
        return this.getURL(new String[]{space, page, attachment}, action, queryString);
    }

    public String getAttachmentURL(String space, String page, String attachment, String action) {
        return this.getAttachmentURL(space, page, attachment, action, "");
    }

    public String getAttachmentURL(String space, String page, String attachment) {
        return this.getAttachmentURL(space, page, attachment, "download");
    }

    public void recacheSecretToken() {
        String previousURL = this.getDriver().getCurrentUrl();
        this.gotoPage("XWiki", "Register", "register");
        try {
            WebElement tokenInput = this.getDriver().findElement(By.xpath((String)"//input[@name='form_token']"));
            this.secretToken = tokenInput.getAttribute("value");
        }
        catch (NoSuchElementException exception) {
            System.out.println("Warning: Failed to cache anti-CSRF secret token, some tests might fail!");
            exception.printStackTrace();
        }
        this.getDriver().get(previousURL);
    }

    public String getSecretToken() {
        if (this.secretToken == null) {
            System.out.println("Warning: No cached anti-CSRF token found. Make sure to call recacheSecretToken() before getSecretToken(), otherwise this test might fail.");
            return "";
        }
        return this.secretToken;
    }

    public String escapeURL(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setDriverImplicitWait(WebDriver driver) {
        driver.manage().timeouts().implicitlyWait((long)this.getTimeout(), TimeUnit.SECONDS);
    }

    public boolean isInWYSIWYGEditMode() {
        return this.getDriver().findElements(By.xpath((String)"//div[@id='tmCurrentEditor']//a/strong[contains(text(), 'WYSIWYG')]")).size() > 0;
    }

    public boolean isInWikiEditMode() {
        return this.getDriver().findElements(By.xpath((String)"//div[@id='tmCurrentEditor']//a/strong[contains(text(), 'Wiki')]")).size() > 0;
    }

    public boolean isInViewMode() {
        return this.getDriver().findElements(By.id((String)"tmEdit")).size() > 0;
    }

    public boolean isInSourceViewMode() {
        return this.getDriver().findElements(By.xpath((String)"//textarea[@class = 'wiki-code']")).size() > 0;
    }

    public boolean isInInlineEditMode() {
        String currentURL = this.getDriver().getCurrentUrl();
        return currentURL.contains("editor=inline") || currentURL.contains("/inline/");
    }

    public boolean isInRightsEditMode() {
        return this.getDriver().getCurrentUrl().contains("editor=rights");
    }

    public boolean isInObjectEditMode() {
        return this.getDriver().getCurrentUrl().contains("editor=object");
    }

    public boolean isInClassEditMode() {
        return this.getDriver().getCurrentUrl().contains("editor=class");
    }

    public boolean isInDeleteMode() {
        return this.getDriver().getCurrentUrl().contains("/delete/");
    }

    public boolean isInRenameMode() {
        return this.getDriver().getCurrentUrl().contains("xpage=rename");
    }

    public boolean isInCreateMode() {
        return this.getDriver().getCurrentUrl().contains("/create/");
    }

    public void forceGuestUser() {
        this.setSession(null);
    }

    public void addObject(String space, String page, String className, Object ... properties) {
        this.gotoPage(space, page, "objectadd", this.toQueryParameters(className, null, properties));
    }

    public void addObject(String space, String page, String className, Map<String, ?> properties) {
        this.gotoPage(space, page, "objectadd", this.toQueryParameters(className, null, properties));
    }

    public void deleteObject(String space, String page, String className, int objectNumber) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("classname=");
        queryString.append(this.escapeURL(className));
        queryString.append('&');
        queryString.append("classid=");
        queryString.append(objectNumber);
        this.gotoPage(space, page, "objectremove", queryString.toString());
    }

    public void updateObject(String space, String page, String className, int objectNumber, Map<String, ?> properties) {
        this.gotoPage(space, page, "save", this.toQueryParameters(className, (Integer)objectNumber, properties));
    }

    public void updateObject(String space, String page, String className, int objectNumber, Object ... properties) {
        this.gotoPage(space, page, "save", this.toQueryParameters(className, (Integer)objectNumber, properties));
    }

    public ClassEditPage addClassProperty(String space, String page, String propertyName, String propertyType) {
        this.gotoPage(space, page, "propadd", "propname", propertyName, "proptype", propertyType);
        return new ClassEditPage();
    }

    public String toQueryString(Object ... queryParameters) {
        return this.toQueryString(this.toQueryParameters(queryParameters));
    }

    public String toQueryString(Map<String, ?> queryParameters) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ?> entry : queryParameters.entrySet()) {
            this.addQueryStringEntry(builder, entry.getKey(), entry.getValue());
            builder.append('&');
        }
        return builder.toString();
    }

    public void addQueryStringEntry(StringBuilder builder, String key, Object value) {
        if (value != null) {
            if (value instanceof Iterable) {
                for (Object element : (Iterable)value) {
                    this.addQueryStringEntry(builder, key, element.toString());
                    builder.append('&');
                }
            } else {
                this.addQueryStringEntry(builder, key, value.toString());
            }
        } else {
            this.addQueryStringEntry(builder, key, null);
        }
    }

    public void addQueryStringEntry(StringBuilder builder, String key, String value) {
        builder.append(this.escapeURL(key));
        if (value != null) {
            builder.append('=');
            builder.append(this.escapeURL(value));
        }
    }

    public Map<String, ?> toQueryParameters(Object ... properties) {
        return this.toQueryParameters(null, null, properties);
    }

    public Map<String, ?> toQueryParameters(String className, Integer objectNumber, Object ... properties) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("classname", className);
        for (int i = 0; i < properties.length; i += 2) {
            int nextIndex = i + 1;
            queryParameters.put(this.toQueryParameterKey(className, objectNumber, (String)properties[i]), nextIndex < properties.length ? properties[nextIndex] : null);
        }
        return queryParameters;
    }

    public Map<String, ?> toQueryParameters(String className, Integer objectNumber, Map<String, ?> properties) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (className != null) {
            queryParameters.put("classname", className);
        }
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            queryParameters.put(this.toQueryParameterKey(className, objectNumber, entry.getKey()), (String)entry.getValue());
        }
        return queryParameters;
    }

    public String toQueryParameterKey(String className, Integer objectNumber, String key) {
        if (className == null) {
            return key;
        }
        StringBuilder keyBuilder = new StringBuilder(className);
        keyBuilder.append('_');
        if (objectNumber != null) {
            keyBuilder.append(objectNumber);
            keyBuilder.append('_');
        }
        keyBuilder.append(key);
        return keyBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementWithoutWaiting(WebDriver driver, By by) {
        driver.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        try {
            WebElement webElement = driver.findElement(by);
            return webElement;
        }
        finally {
            this.setDriverImplicitWait(driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsWithoutWaiting(WebDriver driver, By by) {
        driver.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        try {
            List list = driver.findElements(by);
            return list;
        }
        finally {
            this.setDriverImplicitWait(driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementWithoutWaiting(WebDriver driver, WebElement element, By by) {
        driver.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        try {
            WebElement webElement = element.findElement(by);
            return webElement;
        }
        finally {
            this.setDriverImplicitWait(driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsWithoutWaiting(WebDriver driver, WebElement element, By by) {
        driver.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        try {
            List list = element.findElements(by);
            return list;
        }
        finally {
            this.setDriverImplicitWait(driver);
        }
    }

    public boolean hasElement(By by) {
        try {
            this.getDriver().findElement(by);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasElement(WebElement element, By by) {
        try {
            element.findElement(by);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public ObjectEditPage editObjects(String space, String page) {
        this.gotoPage(space, page, "edit", "editor=object");
        return new ObjectEditPage();
    }

    public ClassEditPage editClass(String space, String page) {
        this.gotoPage(space, page, "edit", "editor=class");
        return new ClassEditPage();
    }

    public String getVersion() throws Exception {
        Xwiki xwiki = (Xwiki)this.getRESTResource("", null, new Object[0]);
        return xwiki.getVersion();
    }

    public String getMavenVersion() throws Exception {
        String version = this.getVersion();
        int index = version.indexOf(45);
        if (index > 0) {
            version = version.substring(0, index) + "-SNAPSHOT";
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachFile(String space, String page, String name, File file, boolean failIfExists) throws Exception {
        FileInputStream is = new FileInputStream(file);
        try {
            this.attachFile(space, page, name, is, failIfExists);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public void attachFile(String space, String page, String name, InputStream is, boolean failIfExists, UsernamePasswordCredentials credentials) throws Exception {
        if (credentials != null) {
            this.adminHTTPClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
        this.attachFile(space, page, name, is, failIfExists);
    }

    public void attachFile(String space, String page, String name, InputStream is, boolean failIfExists) throws Exception {
        if (!this.pageExists(space, page)) {
            this.createPage(space, page, null, null);
        }
        StringBuilder url = new StringBuilder(BASE_REST_URL);
        url.append("wikis/xwiki/spaces/");
        url.append(this.escapeURL(space));
        url.append("/pages/");
        url.append(this.escapeURL(page));
        url.append("/attachments/");
        url.append(this.escapeURL(name));
        if (failIfExists) {
            this.executePut(url.toString(), is, "application/octet-stream", Response.Status.CREATED.getStatusCode());
        } else {
            this.executePut(url.toString(), is, "application/octet-stream", Response.Status.CREATED.getStatusCode(), Response.Status.ACCEPTED.getStatusCode());
        }
    }

    public void importXar(File file) throws Exception {
        this.attachFile("XWiki", "Import", file.getName(), file, false);
        this.executeGet(BASE_BIN_URL + "import/XWiki/Import?historyStrategy=add&importAsBackup=true&ajax&action=import&name=" + this.escapeURL(file.getName()), Response.Status.OK.getStatusCode());
    }

    public InputStream getRESTInputStream(String resourceUri, Map<String, Object[]> queryParams, Object ... elements) throws Exception {
        UriBuilder builder = UriBuilder.fromUri((String)BASE_REST_URL.substring(0, BASE_REST_URL.length() - 1)).path(!resourceUri.isEmpty() && resourceUri.charAt(0) == '/' ? resourceUri.substring(1) : resourceUri);
        if (queryParams != null) {
            for (Map.Entry<String, Object[]> entry : queryParams.entrySet()) {
                builder.queryParam(entry.getKey(), entry.getValue());
            }
        }
        String url = builder.build(elements).toString();
        return this.executeGet(url, Response.Status.OK.getStatusCode()).getResponseBodyAsStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRESTBuffer(String resourceUri, Map<String, Object[]> queryParams, Object ... elements) throws Exception {
        byte[] buffer;
        InputStream is = this.getRESTInputStream(resourceUri, queryParams, elements);
        try {
            buffer = IOUtils.toByteArray((InputStream)is);
        }
        finally {
            is.close();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getRESTResource(String resourceUri, Map<String, Object[]> queryParams, Object ... elements) throws Exception {
        Object resource;
        InputStream is = this.getRESTInputStream(resourceUri, queryParams, elements);
        try {
            resource = unmarshaller.unmarshal(is);
        }
        finally {
            is.close();
        }
        return (T)resource;
    }

    protected GetMethod executeGet(String uri, int expectedCode) throws Exception {
        GetMethod getMethod = new GetMethod(uri);
        int code = this.adminHTTPClient.executeMethod((HttpMethod)getMethod);
        if (code != expectedCode) {
            throw new Exception("Failed to execute get [" + uri + "] with code [" + code + "]");
        }
        return getMethod;
    }

    protected PutMethod executePut(String uri, InputStream content, String mediaType, int ... expectedCodes) throws Exception {
        PutMethod putMethod = new PutMethod(uri);
        InputStreamRequestEntity entity = new InputStreamRequestEntity(content, mediaType);
        putMethod.setRequestEntity((RequestEntity)entity);
        int code = this.adminHTTPClient.executeMethod((HttpMethod)putMethod);
        if (!ArrayUtils.contains((int[])expectedCodes, (int)code)) {
            throw new Exception("Failed to execute put [" + uri + "] with code [" + code + "]");
        }
        return putMethod;
    }

    public class Session {
        private final Set<Cookie> cookies;
        private final String secretToken;

        private Session(final Set<Cookie> cookies, String secretToken) {
            this.cookies = Collections.unmodifiableSet(new HashSet<Cookie>(){
                {
                    this.addAll(cookies);
                }
            });
            this.secretToken = secretToken;
        }

        private Set<Cookie> getCookies() {
            return this.cookies;
        }

        private String getSecretToken() {
            return this.secretToken;
        }
    }
}

