/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.browser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.xwiki.test.ui.browser.IgnoreBrowser;
import org.xwiki.test.ui.browser.IgnoreBrowsers;

public class BrowserTestRule
implements TestRule {
    private String currentBrowserName;
    private String currentBrowserVersion;

    public BrowserTestRule(WebDriver driver) {
        Capabilities capability = ((RemoteWebDriver)driver).getCapabilities();
        this.currentBrowserName = capability.getBrowserName();
        this.currentBrowserVersion = capability.getVersion();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                IgnoreBrowsers ignoreBrowsers;
                ArrayList<IgnoreBrowser> ignoredBrowsersList = new ArrayList<IgnoreBrowser>();
                IgnoreBrowser ignoreBrowser = (IgnoreBrowser)description.getAnnotation(IgnoreBrowser.class);
                if (ignoreBrowser != null) {
                    ignoredBrowsersList.add(ignoreBrowser);
                }
                if ((ignoreBrowsers = (IgnoreBrowsers)description.getAnnotation(IgnoreBrowsers.class)) != null) {
                    ignoredBrowsersList.addAll(Arrays.asList(ignoreBrowsers.value()));
                }
                for (IgnoreBrowser ignoredBrowser : ignoredBrowsersList) {
                    Pattern browserNamePattern = Pattern.compile(ignoredBrowser.value());
                    Pattern browserVersionPattern = Pattern.compile(ignoredBrowser.version());
                    if (!browserNamePattern.matcher(BrowserTestRule.this.currentBrowserName).matches() || !ignoredBrowser.version().isEmpty() && !browserVersionPattern.matcher(BrowserTestRule.this.currentBrowserVersion).matches()) continue;
                    throw new AssumptionViolatedException(ignoredBrowser.reason());
                }
                base.evaluate();
            }
        };
    }
}

