/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.HashMap;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BasePage;
import org.xwiki.test.ui.po.FormElement;

public abstract class AbstractRegistrationPage
extends BasePage {
    @FindBy(id="register")
    private WebElement registerFormElement;
    private FormElement form;

    public abstract void clickRegister();

    public void fillInJohnSmithValues() {
        this.fillRegisterForm("John", "Smith", "JohnSmith", "WeakPassword", "WeakPassword", "johnsmith@xwiki.org");
    }

    public void fillRegisterForm(String firstName, String lastName, String username, String password, String confirmPassword, String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (firstName != null) {
            map.put("register_first_name", firstName);
        }
        if (lastName != null) {
            map.put("register_last_name", lastName);
        }
        if (username != null) {
            map.put("xwikiname", username);
        }
        if (password != null) {
            map.put("register_password", password);
        }
        if (confirmPassword != null) {
            map.put("register2_password", confirmPassword);
        }
        if (email != null) {
            map.put("register_email", email);
        }
        this.getForm().fillFieldsByName(map);
        if (username != null) {
            while (!username.equals(this.getForm().getFieldValue(By.name((String)"xwikiname")))) {
                this.getForm().setFieldValue(By.name((String)"xwikiname"), username);
            }
        }
    }

    private FormElement getForm() {
        if (this.form == null) {
            this.form = new FormElement(this.registerFormElement);
        }
        return this.form;
    }

    public List<WebElement> getValidationFailureMessages() {
        return AbstractRegistrationPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)"//dd/span[@class='LV_validation_message LV_invalid']"));
    }

    public boolean validationFailureMessagesInclude(String message) {
        return AbstractRegistrationPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)("//dd/span[@class='LV_validation_message LV_invalid' and . = '" + message + "']"))).size() > 0;
    }

    public void triggerLiveValidation() {
        this.executeJavascript("try{ document.getElementById('register_first_name').focus(); document.getElementById('register').onsubmit(null); }catch(err){}", new Object[0]);
    }

    public boolean isLiveValidationEnabled() {
        return !AbstractRegistrationPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)"//div[@id='mainContentArea']/script")).isEmpty();
    }
}

