/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.TestUtils;
import org.xwiki.test.ui.po.ViewPage;

public class LoginPage
extends ViewPage {
    @FindBy(id="j_username")
    private WebElement usernameText;
    @FindBy(id="j_password")
    private WebElement passwordText;
    @FindBy(id="rememberme")
    private WebElement rememberMeCheckbox;
    @FindBy(xpath="//input[@type='submit' and @value='Log-in']")
    private WebElement submitButton;
    @FindBy(xpath="//div[@class='errormessage']")
    private WebElement loginErrorDiv;

    public static LoginPage gotoPage() {
        LoginPage.getUtil().gotoPage("XWiki", "XWikiLogin", "login");
        return new LoginPage();
    }

    public void loginAsAdmin() {
        this.loginAs(TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword(), true);
    }

    public void loginAs(String username, String password, boolean rememberMe) {
        if (!this.isAuthenticated() || !this.getCurrentUser().equals(username)) {
            this.usernameText.sendKeys(new CharSequence[]{username});
            this.passwordText.sendKeys(new CharSequence[]{password});
            if (rememberMe) {
                this.rememberMeCheckbox.click();
            }
            this.submitButton.click();
        }
    }

    public void loginAs(String username, String password) {
        this.loginAs(username, password, false);
    }

    public boolean hasInvalidCredentialsErrorMessage() {
        return this.loginErrorDiv.getText().equals("Invalid credentials");
    }
}

