/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.test.ui.po.BasePage;
import org.xwiki.test.ui.po.ViewPage;

public class EditPage
extends BasePage {
    @FindBy(name="action_saveandcontinue")
    protected WebElement saveandcontinue;
    @FindBy(name="action_save")
    protected WebElement save;
    @FindBy(name="action_cancel")
    protected WebElement cancel;
    @FindBy(xpath="//*[@id = 'tmCurrentEditor']//*[@class = 'tme hastype']")
    protected WebElement selectedEditMenuItem;
    @FindBy(id="xwikidocsyntaxinput2")
    protected WebElement syntaxIdSelect;
    @FindBy(id="editmenu")
    private WebElement editMenuBar;
    @FindBy(id="tmCurrentEditor")
    private WebElement currentEditorMenu;

    public void clickSaveAndContinue() {
        this.clickSaveAndContinue(true);
    }

    public void clickSaveAndContinue(boolean wait) {
        this.saveandcontinue.click();
        if (wait) {
            this.waitForNotificationSuccessMessage("Saved");
        }
    }

    public ViewPage clickSaveAndView() {
        this.save.click();
        return new ViewPage();
    }

    public ViewPage clickCancel() {
        this.cancel.click();
        return new ViewPage();
    }

    public Editor getEditor() {
        return Editor.valueOf(this.selectedEditMenuItem.getText().toUpperCase());
    }

    public String getSyntaxId() {
        return this.syntaxIdSelect.getAttribute("value");
    }

    public void setSyntaxId(String syntaxId) {
        Select select = new Select(this.syntaxIdSelect);
        select.selectByValue(syntaxId);
    }

    @Override
    protected void clickContentMenuEditSubMenuEntry(String id) {
        new Actions(this.getDriver()).moveToElement(this.logo).moveToElement(this.currentEditorMenu).perform();
        this.getDriver().findElement(By.xpath((String)("//a[@id='" + id + "']"))).click();
    }

    public static enum Editor {
        WYSIWYG("WYSIWYG"),
        WIKI("Wiki"),
        RIGHTS("Access Rights"),
        OBJECT("Objects"),
        CLASS("Class");

        private static final Map<String, Editor> BY_PRETTY_NAME;
        private final String prettyName;

        private Editor(String prettyName) {
            this.prettyName = prettyName;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public static Editor byPrettyName(String prettyName) {
            return BY_PRETTY_NAME.get(prettyName);
        }

        static {
            BY_PRETTY_NAME = new HashMap<String, Editor>();
            for (Editor editor : Editor.values()) {
                BY_PRETTY_NAME.put(editor.getPrettyName(), editor);
            }
        }
    }
}

