/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.xwiki.test.ui.po.BaseElement;

public class UserPicker
extends BaseElement {
    private final WebElement textInput;

    public UserPicker(WebElement textInput) {
        this.textInput = textInput;
    }

    public UserPicker sendKeys(CharSequence ... keysToSend) {
        this.textInput.sendKeys(keysToSend);
        return this;
    }

    public UserPicker clear() {
        this.textInput.clear();
        return this;
    }

    public String getValue() {
        return this.textInput.getAttribute("value");
    }

    public WebElement getClearSelectionLink() {
        String xpath = "preceding-sibling::a[@class = 'clear-tool' and position() = last()]";
        return UserPicker.getUtil().findElementWithoutWaiting(this.getDriver(), this.textInput, By.xpath((String)xpath));
    }

    public UserPicker waitForSuggestions() {
        UserPicker.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !UserPicker.this.textInput.getAttribute("class").contains("loading") && this.isSuggestListDisplayed(driver);
            }

            private boolean isSuggestListDisplayed(WebDriver driver) {
                WebElement suggestItems = driver.findElement(By.className((String)"suggestItems"));
                WebElement suggestList = suggestItems.findElement(By.className((String)"suggestList"));
                return suggestList.isDisplayed() && Double.parseDouble(suggestItems.getCssValue("opacity")) == 1.0;
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPicker waitForSuggestionsToDisappear(int timeout) {
        int previousTimeout = UserPicker.getUtil().getTimeout();
        UserPicker.getUtil().setTimeout(timeout);
        try {
            UserPicker.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver driver) {
                    return driver.findElements(By.className((String)"suggestItems")).size() == 0;
                }
            });
        }
        finally {
            UserPicker.getUtil().setTimeout(previousTimeout);
        }
        return this;
    }

    public UserPicker waitForSuggestionsToFadeOut() {
        return this.waitForSuggestionsToDisappear(2);
    }

    public UserPicker waitForSuggestionsToDisappear() {
        return this.waitForSuggestionsToDisappear(35);
    }

    public UserPicker select(String userNameOrAlias) {
        UserPicker.getUtil().findElementWithoutWaiting(this.getDriver(), By.xpath((String)("//ul[@class = 'xlist suggestList']/li[contains(., '" + userNameOrAlias + "')]"))).click();
        return this;
    }

    public List<UserElement> getSuggestions() {
        ArrayList<UserElement> suggestions = new ArrayList<UserElement>();
        for (WebElement item : UserPicker.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)"//ul[@class = 'xlist suggestList']/li"))) {
            suggestions.add(new UserElement(item));
        }
        return suggestions;
    }

    public List<UserElement> getAcceptedSuggestions() {
        ArrayList<UserElement> acceptedSuggestions = new ArrayList<UserElement>();
        for (WebElement item : UserPicker.getUtil().findElementsWithoutWaiting(this.getDriver(), this.textInput, By.xpath((String)"preceding-sibling::ul[contains(@class, 'accepted-suggestions') and position() = last()]/li"))) {
            acceptedSuggestions.add(new UserElement(item));
        }
        return acceptedSuggestions;
    }

    public UserPicker moveMouseOver() {
        new Actions(this.getDriver()).moveToElement(this.textInput).perform();
        return this;
    }

    public UserPicker waitToLoad() {
        UserPicker.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String classNames = UserPicker.this.textInput.getAttribute("class");
                return classNames.contains("initialized") && !classNames.contains("loading");
            }
        });
        return this;
    }

    public static class UserElement
    extends BaseElement {
        private WebElement container;

        public UserElement(WebElement container) {
            this.container = container;
        }

        public WebElement getAvatar() {
            return UserElement.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, By.className((String)"icon"));
        }

        public String getName() {
            String name = UserElement.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, By.className((String)"user-name")).getText();
            List<WebElement> delete = UserElement.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, By.className((String)"delete-tool"));
            if (delete.size() > 0) {
                name = StringUtils.removeEnd((String)name, (String)delete.get(0).getText());
            }
            return name;
        }

        public String getAlias() {
            return UserElement.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, By.className((String)"user-alias")).getText();
        }

        public String getText() {
            return this.container.getText();
        }

        public void delete() {
            new Actions(this.getDriver()).moveToElement(this.container).click(UserElement.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, By.className((String)"delete-tool"))).perform();
        }

        public void moveMouseOver() {
            new Actions(this.getDriver()).moveToElement(this.container).perform();
        }

        public void moveBefore(UserElement user) {
            new Actions(this.getDriver()).clickAndHold(this.container).moveToElement(user.container, 1, -3).release().perform();
        }
    }
}

