/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tools.jetty.listener;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.xwiki.tools.jetty.listener.Messages;

public class NotifyListener
extends AbstractLifeCycle.AbstractLifeCycleListener {
    private static final Logger LOGGER = Log.getLogger(NotifyListener.class);
    private static final String DELIMITER = "----------------------------------";

    public void lifeCycleStarted(LifeCycle event) {
        LOGGER.info(DELIMITER, new Object[0]);
        try {
            String serverUrl = "http://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + System.getProperty("jetty.port", "8080") + "/";
            LOGGER.info(Messages.getString("jetty.startup.notification"), new Object[]{serverUrl});
        }
        catch (UnknownHostException ex) {
            LOGGER.ignore((Throwable)ex);
        }
        LOGGER.info(DELIMITER, new Object[0]);
    }

    public void lifeCycleStopping(LifeCycle event) {
        LOGGER.info(DELIMITER, new Object[0]);
        LOGGER.info(Messages.getString("jetty.stopping.notification"), new Object[0]);
    }

    public void lifeCycleStopped(LifeCycle event) {
        LOGGER.info(Messages.getString("jetty.stopped.notification"), new Object[0]);
    }
}

