/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.backup;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.tool.backup.Importer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.properties.ConverterManager;

public class ImportMojo
extends AbstractMojo {
    public static final String MPKEYPREFIX = "xwiki.extension.";
    public static final String MPNAME_NAME = "name";
    public static final String MPNAME_SUMMARY = "summary";
    public static final String MPNAME_WEBSITE = "website";
    public static final String MPNAME_FEATURES = "features";
    private String databaseName;
    private File hibernateConfig;
    private File sourceDirectory;
    private File xwikiDataDir;
    private MavenProject project;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactFactory factory;
    protected List<ArtifactRepository> remoteRepos;
    private ArtifactRepository local;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Importer importer = new Importer();
        System.setProperty("xwiki.data.dir", this.xwikiDataDir.getAbsolutePath());
        if (this.sourceDirectory != null) {
            try {
                importer.importDocuments(this.sourceDirectory, this.databaseName, this.hibernateConfig);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to import XWiki documents", e);
            }
        }
        try {
            this.importDependencies(importer, this.databaseName, this.hibernateConfig);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to import XAR dependencies", e);
        }
    }

    private void importDependencies(Importer importer, String databaseName, File hibernateConfig) throws Exception {
        XWikiContext xcontext = importer.createXWikiContext(databaseName, hibernateConfig);
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (artifact.isOptional() || !"xar".equals(artifact.getType())) continue;
                this.getLog().info((CharSequence)("  ... Importing XAR file: " + artifact.getFile()));
                importer.importXAR(artifact.getFile(), null, xcontext);
                this.installExtension(artifact, xcontext);
            }
        }
        importer.shutdownHSQLDB(xcontext);
    }

    private void installExtension(Artifact artifact, XWikiContext xcontext) throws ComponentLookupException, InstallException, LocalExtensionRepositoryException, MojoExecutionException {
        ComponentManager componentManager = (ComponentManager)xcontext.get((Object)ComponentManager.class.getName());
        LocalExtensionRepository localExtensionRepository = (LocalExtensionRepository)componentManager.getInstance(LocalExtensionRepository.class);
        InstalledExtensionRepository installedExtensionRepository = (InstalledExtensionRepository)componentManager.getInstance(InstalledExtensionRepository.class);
        DefaultLocalExtension extension = new DefaultLocalExtension(null, new ExtensionId(artifact.getGroupId() + ':' + artifact.getArtifactId(), artifact.getBaseVersion()), artifact.getType());
        extension.setFile(artifact.getFile());
        MavenProject project = this.getMavenProject(artifact);
        this.toExtension(extension, project.getModel(), componentManager);
        LocalExtension localExtension = localExtensionRepository.storeExtension((Extension)extension);
        installedExtensionRepository.installExtension(localExtension, "wiki:xwiki", true);
    }

    private void toExtension(DefaultLocalExtension extension, Model model, ComponentManager componentManager) throws ComponentLookupException {
        String featuresString;
        extension.setName(this.getPropertyString(model, MPNAME_NAME, model.getName()));
        extension.setSummary(this.getPropertyString(model, MPNAME_SUMMARY, model.getDescription()));
        extension.setWebsite(this.getPropertyString(model, MPNAME_WEBSITE, model.getUrl()));
        for (Developer developer : model.getDevelopers()) {
            URL authorURL = null;
            if (developer.getUrl() != null) {
                try {
                    authorURL = new URL(developer.getUrl());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            extension.addAuthor((ExtensionAuthor)new DefaultExtensionAuthor((String)StringUtils.defaultIfBlank((CharSequence)developer.getName(), (CharSequence)developer.getId()), authorURL));
        }
        if (!model.getLicenses().isEmpty()) {
            ExtensionLicenseManager licenseManager = (ExtensionLicenseManager)componentManager.getInstance(ExtensionLicenseManager.class);
            for (License license : model.getLicenses()) {
                extension.addLicense(this.getExtensionLicense(license, licenseManager));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(featuresString = this.getProperty(model, MPNAME_FEATURES)))) {
            featuresString = featuresString.replaceAll("[\r\n]", "");
            ConverterManager converter = (ConverterManager)componentManager.getInstance(ConverterManager.class);
            extension.setFeatures((Collection)converter.convert(List.class, (Object)featuresString));
        }
        for (Dependency mavenDependency : model.getDependencies()) {
            if (mavenDependency.isOptional() || !mavenDependency.getScope().equals("compile") && !mavenDependency.getScope().equals("runtime")) continue;
            extension.addDependency((ExtensionDependency)new DefaultExtensionDependency(mavenDependency.getGroupId() + ':' + mavenDependency.getArtifactId(), (VersionConstraint)new DefaultVersionConstraint(mavenDependency.getVersion())));
        }
    }

    private MavenProject getMavenProject(Artifact artifact) throws MojoExecutionException {
        MavenProject pomProject;
        Artifact pomArtifact = this.factory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        try {
            pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.local);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(String.format("Failed to build project for [%s]", pomArtifact), (Exception)((Object)e));
        }
        return pomProject;
    }

    private String getProperty(Model model, String propertyName) {
        return model.getProperties().getProperty(MPKEYPREFIX + propertyName);
    }

    private String getPropertyString(Model model, String propertyName, String def) {
        return StringUtils.defaultString((String)this.getProperty(model, propertyName), (String)def);
    }

    private ExtensionLicense getExtensionLicense(License license, ExtensionLicenseManager licenseManager) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        return this.createLicenseByName(license.getName(), licenseManager);
    }

    private ExtensionLicense createLicenseByName(String name, ExtensionLicenseManager licenseManager) {
        ExtensionLicense extensionLicense = licenseManager.getLicense(name);
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(name, null);
    }
}

