/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.AsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererDecorator;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererResult;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.internal.AbstractWikiUIExtension;
import org.xwiki.uiextension.internal.WikiUIExtensionParameters;

public class WikiUIExtension
extends AbstractWikiUIExtension
implements BlockAsyncRendererDecorator {
    public static final String CONTEXT_UIX_KEY = "uix";
    public static final String CONTEXT_UIX_DOC_KEY = "doc";
    private final String id;
    private final String extensionPointId;
    private final Provider<XWikiContext> xcontextProvider;
    private WikiUIExtensionParameters parameters;

    public WikiUIExtension(BaseObject baseObject, String roleHint, String id, String extensionPointId, ComponentManager componentManager) throws ComponentLookupException, WikiComponentException {
        super(baseObject, (Type)((Object)UIExtension.class), roleHint, componentManager);
        this.id = id;
        this.extensionPointId = extensionPointId;
        this.xcontextProvider = (Provider)componentManager.getInstance((Type)XWikiContext.TYPE_PROVIDER);
    }

    public void setParameters(WikiUIExtensionParameters parameters) {
        this.parameters = parameters;
    }

    public void setScope(WikiComponentScope scope) {
        this.scope = scope;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getExtensionPointId() {
        return this.extensionPointId;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.parameters != null) {
            return this.parameters.get();
        }
        return Collections.emptyMap();
    }

    private Object before() throws RenderingException {
        XWikiDocument document;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            document = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
        }
        catch (XWikiException e) {
            throw new RenderingException("Failed to get ui extension document", (Throwable)e);
        }
        HashMap<String, Document> uixContext = new HashMap<String, Document>();
        uixContext.put(CONTEXT_UIX_DOC_KEY, document.newDocument(xcontext));
        Map previousUIXContext = (Map)xcontext.get((Object)CONTEXT_UIX_KEY);
        xcontext.put((Object)CONTEXT_UIX_KEY, uixContext);
        return previousUIXContext;
    }

    private void after(Object uixContext) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        xcontext.put((Object)CONTEXT_UIX_KEY, uixContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockAsyncRendererResult render(AsyncRenderer renderer, boolean async, boolean cached) throws RenderingException {
        Object obj = this.before();
        try {
            BlockAsyncRendererResult blockAsyncRendererResult = (BlockAsyncRendererResult)renderer.render(async, cached);
            return blockAsyncRendererResult;
        }
        finally {
            this.after(obj);
        }
    }
}

