/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.UIExtensionFilter;

@Component
@Singleton
@Named(value="sortByParameter")
public class SortByParameterFilter
implements UIExtensionFilter {
    @Override
    public List<UIExtension> filter(List<UIExtension> extensions, String ... parameterKey) {
        ArrayList<UIExtension> results = new ArrayList<UIExtension>();
        results.addAll(extensions);
        if (!StringUtils.isBlank((CharSequence)parameterKey[0])) {
            Collections.sort(results, new UIExtensionParameterComparator(parameterKey[0]));
        }
        return results;
    }

    public class UIExtensionParameterComparator
    implements Comparator<UIExtension> {
        private final String parameterKey;

        public UIExtensionParameterComparator(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public int compare(UIExtension source, UIExtension target) {
            int result = 0;
            if (!source.getParameters().containsKey(this.parameterKey)) {
                result = Integer.MAX_VALUE;
            } else if (!target.getParameters().containsKey(this.parameterKey)) {
                result = Integer.MIN_VALUE;
            } else {
                try {
                    int sourceInt = Integer.parseInt(source.getParameters().get(this.parameterKey));
                    int targetInt = Integer.parseInt(target.getParameters().get(this.parameterKey));
                    result = sourceInt - targetInt;
                }
                catch (NumberFormatException e) {
                    result = source.getParameters().get(this.parameterKey).compareToIgnoreCase(target.getParameters().get(this.parameterKey));
                }
            }
            return result;
        }
    }
}

