/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.internal.template.SUExecutor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.internal.WikiUIExtensionParameters;
import org.xwiki.uiextension.internal.WikiUIExtensionRenderer;

public class WikiUIExtension
implements UIExtension,
WikiComponent {
    public static final String CONTEXT_UIX_KEY = "uix";
    public static final String CONTEXT_UIX_DOC_KEY = "doc";
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiUIExtension.class);
    private final DocumentReference documentReference;
    private final DocumentReference authorReference;
    private final String id;
    private final String extensionPointId;
    private final String roleHint;
    private final SUExecutor suExecutor;
    private WikiUIExtensionParameters parameters;
    private WikiUIExtensionRenderer renderer;
    private WikiComponentScope scope = WikiComponentScope.WIKI;

    public WikiUIExtension(String roleHint, String id, String extensionPointId, ObjectReference objectReference, DocumentReference authorReference, SUExecutor suExecutor) {
        this.roleHint = roleHint;
        this.id = id;
        this.extensionPointId = extensionPointId;
        this.authorReference = authorReference;
        this.documentReference = (DocumentReference)objectReference.getParent();
        this.suExecutor = suExecutor;
    }

    public void setParameters(WikiUIExtensionParameters parameters) {
        this.parameters = parameters;
    }

    public void setRenderer(WikiUIExtensionRenderer renderer) {
        this.renderer = renderer;
    }

    public void setScope(WikiComponentScope scope) {
        this.scope = scope;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getExtensionPointId() {
        return this.extensionPointId;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.parameters != null) {
            return this.parameters.get();
        }
        return Collections.emptyMap();
    }

    @Override
    public Block execute() {
        if (this.renderer != null) {
            try {
                return (Block)this.suExecutor.call((Callable)new Callable<Block>(){

                    @Override
                    public Block call() throws Exception {
                        return WikiUIExtension.this.renderer.execute();
                    }
                }, this.getAuthorReference());
            }
            catch (Exception e) {
                LOGGER.error("Error while executing transformation for extension [{}]", (Object)this.documentReference.toString());
            }
        }
        return new WordBlock("");
    }

    public DocumentReference getDocumentReference() {
        return this.documentReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public Type getRoleType() {
        return UIExtension.class;
    }

    public String getRoleHint() {
        return this.roleHint;
    }

    public WikiComponentScope getScope() {
        return this.scope;
    }
}

