/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;

public abstract class AbstractResourceReferenceResolver
implements ResourceReferenceResolver<ExtendedURL> {
    @Inject
    @Named(value="context")
    protected ComponentManager componentManager;

    protected ResourceReferenceResolver<ExtendedURL> findResourceResolver(String hintPrefix, ResourceType type) throws UnsupportedResourceReferenceException {
        ResourceReferenceResolver resolver;
        DefaultParameterizedType roleType = new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class});
        String roleHint = this.computeResolverHint(hintPrefix, type.getId());
        if (this.componentManager.hasComponent((Type)roleType, roleHint)) {
            try {
                resolver = (ResourceReferenceResolver)this.componentManager.getInstance((Type)roleType, roleHint);
            }
            catch (ComponentLookupException cle) {
                throw new UnsupportedResourceReferenceException(String.format("Failed to lookup Resource Reference Resolver for hint [%s]", roleHint), (Throwable)cle);
            }
        }
        try {
            resolver = (ResourceReferenceResolver)this.componentManager.getInstance((Type)roleType, type.getId());
        }
        catch (ComponentLookupException cle) {
            throw new UnsupportedResourceReferenceException(String.format("Failed to lookup Resource Reference Resolver for type [%s]", type), (Throwable)cle);
        }
        return resolver;
    }

    protected String computeResolverHint(String hintPrefix, String type) {
        return String.format("%s/%s", hintPrefix, type);
    }

    protected void copyParameters(ExtendedURL source, ResourceReference target) {
        for (Map.Entry<String, List<String>> entry : source.getParameters().entrySet()) {
            if (entry.getValue().isEmpty()) {
                target.addParameter(entry.getKey(), null);
                continue;
            }
            target.addParameter(entry.getKey(), entry.getValue());
        }
    }
}

