/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.container.Request;
import org.xwiki.container.RequestInitializer;
import org.xwiki.container.RequestInitializerException;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.url.URLCreationException;
import org.xwiki.url.UnsupportedURLException;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.XWikiURLFactory;

public class XWikiURLRequestInitializer
implements RequestInitializer {
    @Inject
    private Logger logger;
    @Inject
    private XWikiURLFactory<URL, XWikiURL> urlFactory;

    public void initialize(Request request) throws RequestInitializerException {
        if (request instanceof ServletRequest) {
            HttpServletRequest httpServletRequest = ((ServletRequest)request).getHttpServletRequest();
            URL url = this.getURL(httpServletRequest);
            try {
                XWikiURL xwikiURL = this.urlFactory.createURL((Object)url, Collections.singletonMap("ignorePrefix", httpServletRequest.getContextPath()));
                request.setProperty("xwikiurl", (Object)xwikiURL);
            }
            catch (URLCreationException iue) {
                throw new RequestInitializerException(String.format("Failed to extract XWiki URL from [%s]", url), (Throwable)iue);
            }
            catch (UnsupportedURLException uue) {
                this.logger.debug("Unsupported URL type, ignoring [{}]", (Object)url);
            }
        } else {
            this.logger.warn("We currently only support URL extraction for Servlet environments");
        }
    }

    private URL getURL(HttpServletRequest httpServletRequest) throws RequestInitializerException {
        URL result;
        StringBuffer url = httpServletRequest.getRequestURL();
        if (!StringUtils.isEmpty((CharSequence)httpServletRequest.getQueryString())) {
            url.append('?');
            url.append(httpServletRequest.getQueryString());
        }
        try {
            result = new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new RequestInitializerException(String.format("Failed to extract XWiki URL because of invalid Request URL [%s]", url.toString()));
        }
        return result;
    }
}

