/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.container;

import com.xpn.xwiki.XWikiContext;
import java.net.URL;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;

@Component
@Named(value="contextpath")
@Singleton
public class ExtendedURLURLNormalizer
implements URLNormalizer<ExtendedURL> {
    private static final String URL_SEGMENT_DELIMITER = "/";
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configurationSource;
    @Inject
    private Container container;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public ExtendedURL normalize(ExtendedURL partialURL) {
        String contextPath = this.getConfiguredContextPath();
        if (contextPath == null && (contextPath = this.getRequestContextPath()) == null && (contextPath = this.getExecutionContextPath()) == null) {
            throw new RuntimeException(String.format("Failed to normalize the URL [%s] since the application's Servlet context couldn't be computed.", partialURL));
        }
        contextPath = StringUtils.strip((String)contextPath, (String)URL_SEGMENT_DELIMITER);
        ArrayList<String> segments = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)contextPath)) {
            segments.add(contextPath);
        }
        segments.addAll(partialURL.getSegments());
        return new ExtendedURL(segments, partialURL.getParameters());
    }

    private String getConfiguredContextPath() {
        return (String)this.configurationSource.getProperty("xwiki.webapppath");
    }

    private String getRequestContextPath() {
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest) {
            return ((ServletRequest)request).getHttpServletRequest().getContextPath();
        }
        return null;
    }

    private String getExecutionContextPath() {
        URL currentURL = ((XWikiContext)this.xcontextProvider.get()).getURL();
        if (currentURL != null) {
            return StringUtils.substringBefore((String)StringUtils.stripStart((String)currentURL.getPath(), (String)URL_SEGMENT_DELIMITER), (String)URL_SEGMENT_DELIMITER);
        }
        return null;
    }
}

