/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.ModelContext;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.standard.StandardURLConfiguration;

@Component
@Named(value="contextpath+actionservletpath")
@Singleton
public class ContextAndActionURLNormalizer
extends org.xwiki.url.internal.container.ContextAndActionURLNormalizer
implements Initializable {
    private static final String URL_SEGMENT_DELIMITER = "/";
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configurationSource;
    @Inject
    private StandardURLConfiguration urlConfiguration;
    @Inject
    private ModelContext context;
    private String virtualWikiServletMapping;

    public void initialize() {
        super.initialize();
        this.virtualWikiServletMapping = this.urlConfiguration.getWikiPathPrefix();
    }

    public ExtendedURL normalize(ExtendedURL partialURL) {
        String contextPath = StringUtils.strip((String)this.getContextPath(), (String)URL_SEGMENT_DELIMITER);
        if (contextPath == null) {
            throw new RuntimeException(String.format("Failed to normalize the URL [%s] since the application's Servlet context couldn't be computed.", partialURL));
        }
        ArrayList<String> segments = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            segments.add(contextPath);
        }
        List<String> servletPath = this.getActionAndWikiServletMapping();
        for (String segment : servletPath) {
            if (!StringUtils.isNotEmpty((CharSequence)segment)) continue;
            segments.add(segment);
        }
        segments.addAll(partialURL.getSegments());
        return new ExtendedURL(segments, partialURL.getParameters());
    }

    protected String getContextPath() {
        String contextPath = (String)this.configurationSource.getProperty("xwiki.webapppath");
        if (contextPath == null) {
            contextPath = super.getContextPath();
        }
        return contextPath;
    }

    protected List<String> getActionAndWikiServletMapping() {
        String result = super.getActionServletMapping();
        if (StringUtils.equals((CharSequence)this.virtualWikiServletMapping, (CharSequence)result)) {
            return Arrays.asList(this.virtualWikiServletMapping, this.context.getCurrentEntityReference().getRoot().getName());
        }
        return Collections.singletonList(result);
    }
}

