/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.standard.StandardURLConfiguration;
import org.xwiki.url.internal.standard.WikiReferenceExtractor;
import org.xwiki.url.internal.standard.entity.BinEntityResourceReferenceResolver;
import org.xwiki.url.internal.standard.entity.WikiEntityResourceReferenceResolver;

@Component
@Named(value="standard")
@Singleton
public class StandardURLResourceReferenceResolver
implements ResourceReferenceResolver<URL>,
Initializable {
    private static final String IGNORE_PREFIX_KEY = "ignorePrefix";
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private ComponentManager rootComponentManager;
    @Inject
    private StandardURLConfiguration configuration;
    private ResourceReferenceResolver<ExtendedURL> binEntityResourceReferenceResolver;

    public void initialize() throws InitializationException {
        this.registerEntityResourceReferenceResolver(this.configuration.getWikiPathPrefix(), WikiEntityResourceReferenceResolver.class, "path");
        this.registerEntityResourceReferenceResolver(this.configuration.getEntityPathPrefix(), BinEntityResourceReferenceResolver.class, "domain");
        try {
            this.binEntityResourceReferenceResolver = (ResourceReferenceResolver)this.rootComponentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class}), this.computeHint(this.configuration.getEntityPathPrefix()));
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to initialize Standard Resource Reference Resolver", (Throwable)e);
        }
    }

    private void registerEntityResourceReferenceResolver(String registrationHint, Class<? extends ResourceReferenceResolver<ExtendedURL>> registrationImplementation, String wikiExtractorHint) throws InitializationException {
        DefaultComponentDescriptor resolverDescriptor = new DefaultComponentDescriptor();
        resolverDescriptor.setImplementation(registrationImplementation);
        resolverDescriptor.setInstantiationStrategy(ComponentInstantiationStrategy.SINGLETON);
        String hint = this.computeHint(registrationHint);
        resolverDescriptor.setRoleHint(hint);
        resolverDescriptor.setRoleType((Type)new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class}));
        DefaultComponentDependency wikiReferenceExtractorDependency = new DefaultComponentDependency();
        wikiReferenceExtractorDependency.setRoleType(WikiReferenceExtractor.class);
        wikiReferenceExtractorDependency.setRoleHint(wikiExtractorHint);
        wikiReferenceExtractorDependency.setName("wikiExtractor");
        resolverDescriptor.addComponentDependency((ComponentDependency)wikiReferenceExtractorDependency);
        DefaultComponentDependency entityReferenceResolverDependency = new DefaultComponentDependency();
        entityReferenceResolverDependency.setRoleType((Type)new DefaultParameterizedType(null, EntityReferenceResolver.class, new Type[]{EntityReference.class}));
        entityReferenceResolverDependency.setName("defaultReferenceEntityReferenceResolver");
        resolverDescriptor.addComponentDependency((ComponentDependency)entityReferenceResolverDependency);
        try {
            this.rootComponentManager.registerComponent((ComponentDescriptor)resolverDescriptor);
        }
        catch (ComponentRepositoryException e) {
            throw new InitializationException(String.format("Failed to dynamically register Resource Reference Resolver for hint [%s]", hint), (Throwable)e);
        }
    }

    public ResourceReference resolve(URL url, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        ResourceReferenceResolver resolver;
        String ignorePrefix = (String)parameters.get(IGNORE_PREFIX_KEY);
        ExtendedURL extendedURL = new ExtendedURL(url, ignorePrefix);
        String type = (String)extendedURL.getSegments().get(0);
        try {
            resolver = (ResourceReferenceResolver)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class}), this.computeHint(type));
            extendedURL.getSegments().remove(0);
        }
        catch (ComponentLookupException e) {
            try {
                resolver = (ResourceReferenceResolver)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class}), type);
                extendedURL.getSegments().remove(0);
            }
            catch (ComponentLookupException cle) {
                resolver = this.binEntityResourceReferenceResolver;
            }
        }
        return resolver.resolve((Object)extendedURL, parameters);
    }

    private String computeHint(String type) {
        return String.format("standard/%s", type);
    }
}

