/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.group;

import java.util.Collection;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.user.internal.group.AbstractGroupCache;

@Component(roles={GroupsCache.class})
@Singleton
public class GroupsCache
extends AbstractGroupCache {
    public GroupsCache() {
        super("user.membership.groups");
    }

    private String toKey(DocumentReference reference, Collection<String> wikis) {
        StringBuilder builder = new StringBuilder();
        if (wikis != null) {
            for (String wiki : wikis) {
                if (builder.length() > 0) {
                    builder.append('_');
                }
                builder.append(wiki);
            }
        }
        builder.append('_');
        builder.append((String)this.serializer.serialize((EntityReference)reference, new Object[0]));
        return builder.toString();
    }

    public AbstractGroupCache.GroupCacheEntry getCacheEntry(DocumentReference reference, Collection<String> wikis, boolean create) {
        String key = this.toKey(reference, wikis);
        return this.getCacheEntry(key, reference, create);
    }
}

