/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.user.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.CompositeConfigurationSource;

/**
 * Provide configuration data (including all inherited ones) for the Guest user.
 *
 * @version $Id: b8ce00bfb8951376fa4beb7a518aed917ff5d22d $
 * @since 12.6
 */
@Component
@Named("allsuperadminuser")
@Singleton
public class AllSuperAdminConfigurationSource extends CompositeConfigurationSource implements Initializable
{
    @Inject
    @Named("superadminuser")
    private ConfigurationSource superAdminConfigurationSource;

    @Inject
    @Named("documents")
    private ConfigurationSource documentsPreferencesSource;

    @Override
    public void initialize()
    {
        // First source is searched first when a property value is requested.
        addConfigurationSource(this.superAdminConfigurationSource);
        addConfigurationSource(this.documentsPreferencesSource);
    }
}
