/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.user.internal.document;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.user.UserReference;

/**
 * Converts a {@link String} representing a user id into a {@link UserReference}, relatively to the main wiki.
 * <p>
 * For example, {@code XWiki.U1} is always resolved as {@code xwiki:XWiki.U1}.
 *
 * @version $Id: 5eaee13a878e3fe74f042b9be23ee8352126fe84 $
 * @since 12.2
 */
@Component
@Named("document")
@Singleton
public class DefaultDocumentStringUserReferenceResolver extends AbstractDocumentStringUserReferenceResolver
{
    @Inject
    private DocumentReferenceResolver<String> resolver;

    @Override
    protected DocumentReferenceResolver<String> getDocumentReferenceResolver()
    {
        return this.resolver;
    }
}
