/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserReference;

@Component
@Singleton
public class DefaultUserManager
implements UserManager {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    public boolean exists(UserReference userReference) {
        UserReference normalizedUserReference = userReference;
        if (normalizedUserReference == null) {
            normalizedUserReference = CurrentUserReference.INSTANCE;
        }
        boolean exists = GuestUserReference.INSTANCE == normalizedUserReference || SuperAdminUserReference.INSTANCE == normalizedUserReference ? false : this.resolveUserManager(normalizedUserReference).exists(normalizedUserReference);
        return exists;
    }

    private UserManager resolveUserManager(UserReference userReference) {
        try {
            return (UserManager)this.componentManager.getInstance(UserManager.class, userReference.getClass().getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(String.format("Failed to find user manager for role [%s] and hint [%s]", UserManager.class.getName(), userReference.getClass().getName()), e);
        }
    }
}

