/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.ConfigurationSourceAuthorization;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.internal.DefaultUserProperties;
import org.xwiki.user.internal.document.DocumentUserReference;

public abstract class AbstractDocumentUserPropertiesResolver
implements UserPropertiesResolver {
    @Inject
    protected Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="normaluser")
    protected ConfigurationSourceAuthorization authorization;
    @Inject
    protected AuthorizationManager authorizationManager;

    public UserProperties resolve(UserReference userReference, Object ... parameters) {
        if (!(userReference instanceof DocumentUserReference)) {
            throw new IllegalArgumentException(String.format("You need to pass a user reference of type [%s]", DocumentUserReference.class.getName()));
        }
        DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
        return new DefaultUserProperties(this.getConfigurationSource(documentUserReference, this.authorization, this.authorizationManager, this.contextProvider));
    }

    protected abstract ConfigurationSource getConfigurationSource(DocumentUserReference var1, ConfigurationSourceAuthorization var2, AuthorizationManager var3, Provider<XWikiContext> var4);
}

