/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import org.apache.commons.lang3.StringUtils;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

public abstract class AbstractUserReferenceResolver<T>
implements UserReferenceResolver<T> {
    private static final String GUEST_STRING = "XWikiGuest";
    private static final String SUPERADMIN_STRING = "superadmin";

    private boolean isGuest(String userName) {
        return GUEST_STRING.equalsIgnoreCase(userName);
    }

    private boolean isSuperAdmin(String userName) {
        return SUPERADMIN_STRING.equalsIgnoreCase(userName);
    }

    protected UserReference resolveName(String userName) {
        CurrentUserReference reference = null;
        if (StringUtils.isEmpty((CharSequence)userName)) {
            reference = CurrentUserReference.INSTANCE;
        } else if (this.isGuest(userName)) {
            reference = GuestUserReference.INSTANCE;
        } else if (this.isSuperAdmin(userName)) {
            reference = SuperAdminUserReference.INSTANCE;
        }
        return reference;
    }
}

