/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;

public class XWikiWebappResourceLoader
extends ResourceLoader {
    private static final String SLASH = "/";
    private String[] paths;
    private Environment environment;
    private String rootPath;
    private Map<String, String> templatePathsCache = new ConcurrentHashMap<String, String>();

    public void init(ExtProperties configuration) {
        this.environment = this.getEnvironment();
        this.paths = configuration.getStringArray("path");
        if (this.paths == null || this.paths.length == 0) {
            this.paths = new String[1];
            this.paths[0] = SLASH;
        } else {
            for (int i = 0; i < this.paths.length; ++i) {
                this.paths[i] = StringUtils.appendIfMissing((String)this.paths[i], (CharSequence)SLASH, (CharSequence[])new CharSequence[0]);
                this.log.info("Added template path [{}]", (Object)this.paths[i]);
            }
        }
        if (this.environment instanceof ServletEnvironment) {
            this.rootPath = ((ServletEnvironment)this.environment).getServletContext().getRealPath(SLASH);
        } else {
            URL root = this.environment.getResource(SLASH);
            if (root != null && root.getProtocol().equals("file")) {
                try {
                    this.rootPath = new File(root.toURI()).toString();
                }
                catch (URISyntaxException e) {
                    this.log.warn("Failed to find real path for root resource");
                }
            }
        }
    }

    private Environment getEnvironment() {
        try {
            return (Environment)this.getComponentManager().getInstance(Environment.class);
        }
        catch (ComponentLookupException e) {
            throw new VelocityException("Cannot initialize Velocity subsystem: missing Environment component implementation");
        }
    }

    private ComponentManager getComponentManager() {
        ComponentManager cm = (ComponentManager)this.rsvc.getApplicationAttribute((Object)ComponentManager.class.getName());
        if (cm == null) {
            throw new VelocityException("Cannot initialize Velocity subsystem: missing Component Manager in Velocity Application Attribute");
        }
        return cm;
    }

    private String cleanName(String source) {
        String name = source;
        int index = -1;
        while (name.length() > index + 1 && name.charAt(index + 1) == '/') {
            ++index;
        }
        if (index > -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
        if (StringUtils.isEmpty((CharSequence)source)) {
            throw new ResourceNotFoundException("WebappResourceLoader: No template name provided");
        }
        String name = this.cleanName(source);
        Exception exception = null;
        for (int i = 0; i < this.paths.length; ++i) {
            String path = this.paths[i] + name;
            try {
                InputStream stream = this.environment.getResourceAsStream(path);
                if (stream == null) continue;
                this.templatePathsCache.put(name, this.paths[i]);
                return new InputStreamReader(stream, encoding);
            }
            catch (Exception e) {
                if (exception != null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Could not load [{}]", (Object)path, (Object)e);
                }
                exception = e;
            }
        }
        String msg = "Resource [" + name + "] not found.";
        if (exception == null) {
            throw new ResourceNotFoundException(msg);
        }
        throw new ResourceNotFoundException(msg, exception);
    }

    private File getCachedFile(String rootPath, String resourceName) {
        String name = this.cleanName(resourceName);
        String savedPath = this.templatePathsCache.get(name);
        return new File(rootPath + savedPath, name);
    }

    public boolean isSourceModified(Resource resource) {
        if (this.rootPath == null) {
            return false;
        }
        File cachedFile = this.getCachedFile(this.rootPath, resource.getName());
        if (!cachedFile.exists()) {
            return true;
        }
        File currentFile = null;
        for (int i = 0; i < this.paths.length && !(currentFile = new File(this.rootPath + this.paths[i], resource.getName())).canRead(); ++i) {
        }
        if (cachedFile.equals(currentFile) && cachedFile.canRead()) {
            return cachedFile.lastModified() != resource.getLastModified();
        }
        return true;
    }

    public long getLastModified(Resource resource) {
        if (this.rootPath == null) {
            return 0L;
        }
        File cachedFile = this.getCachedFile(this.rootPath, resource.getName());
        if (cachedFile.canRead()) {
            return cachedFile.lastModified();
        }
        return 0L;
    }
}

