/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.velocity.internal.DefaultVelocityConfiguration;
import org.xwiki.velocity.internal.ResourceLoaderInitializer;
import org.xwiki.velocity.internal.XWikiDateTool;
import org.xwiki.velocity.internal.XWikiMathTool;
import org.xwiki.velocity.internal.XWikiNumberTool;

@Component
@Singleton
public class XWikiVelocityConfiguration
extends DefaultVelocityConfiguration {
    @Inject
    private XWikiNumberTool numberTool;
    @Inject
    private XWikiDateTool dateTool;
    @Inject
    private XWikiMathTool mathTool;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        super.initialize();
        this.defaultTools.put("numbertool", (Object)this.numberTool);
        this.defaultTools.put("datetool", (Object)this.dateTool);
        this.defaultTools.put("mathttool", (Object)this.mathTool);
        if (this.componentManager.hasComponent(ResourceLoaderInitializer.class)) {
            try {
                ResourceLoaderInitializer resourceLoader = (ResourceLoaderInitializer)this.componentManager.getInstance(ResourceLoaderInitializer.class);
                resourceLoader.initialize(this.defaultProperties);
            }
            catch (ComponentLookupException e) {
                throw new InitializationException("Failed to lookup the ResourceLoader implementation", (Throwable)e);
            }
        } else {
            this.logger.debug("Could not find any ResourceLoader implementation");
        }
    }
}

